/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.dcdx;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.provider.Messages;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;

public enum OutputFormatType {
    C_ARRAY("c_array", () -> Messages.get().OutputFormatType_CArray),
    BINARY("binary", () -> Messages.get().OutputFormatType_Binary),
    UNSUPPORTED("unsupported", () -> Messages.get().OutputFormatType_Unsupported);

    private final String typeId;
    private final Supplier<@Nullable String> localizedNameSupplier;

    private OutputFormatType(String typeId, Supplier<String> localizedNameSupplier) {
        this.typeId = typeId;
        this.localizedNameSupplier = localizedNameSupplier;
    }

    public String getId() {
        return this.typeId;
    }

    public String getLocalizedName() {
        String localizedName = this.localizedNameSupplier.get();
        return localizedName != null && !localizedName.isEmpty() ? localizedName : this.typeId;
    }

    public static OutputFormatType fromString(String typeId) {
        OutputFormatType[] outputFormatTypeArray = OutputFormatType.values();
        int n = outputFormatTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OutputFormatType t = outputFormatTypeArray[n2];
            if (t.getId().equals(typeId)) {
                return t;
            }
            ++n2;
        }
        return UNSUPPORTED;
    }

    public static @Nullable OutputFormatType fromLocalizedName(String localizedName) {
        OutputFormatType[] outputFormatTypeArray = OutputFormatType.values();
        int n = outputFormatTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OutputFormatType t = outputFormatTypeArray[n2];
            if (t.getLocalizedName().equals(localizedName)) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    public static Collection<@NonNull OutputFormatType> supportedValues() {
        return (Collection)Arrays.asList(OutputFormatType.values()).stream().filter(v -> !UNSUPPORTED.equals(v)).collect(CollectorsUtils.toList());
    }
}

