/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.pins;

import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.storage.pins.StorageConnectorPin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@NonNullByDefault
@Root(strict=false, name="connector")
public class StorageConnector {
    @Attribute(name="id", required=true)
    protected String id;
    @Attribute(name="name", required=true)
    protected String name;
    @ElementList(name="pins", entry="pin", required=false)
    @Nullable
    protected @ElementList(name="pins", entry="pin", required=false) @Nullable ArrayList<StorageConnectorPin> pins;

    StorageConnector() {
        this.id = "";
        this.name = "";
    }

    public StorageConnector(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<StorageConnectorPin> getPins() {
        return this.pins != null ? this.pins : Collections.emptyList();
    }

    public void setPins(@Nullable ArrayList<StorageConnectorPin> pins) {
        this.pins = pins;
    }

    public synchronized boolean addPin(StorageConnectorPin pin) {
        ArrayList<StorageConnectorPin> pinsLoc = this.pins;
        if (pinsLoc == null) {
            pinsLoc = this.pins = new ArrayList();
        }
        boolean result = pinsLoc.add(pin);
        pinsLoc.sort(Comparator.comparing(StorageConnectorPin::getId));
        return result;
    }

    public String toString() {
        return "StorageConnector [id=" + this.id + ", name=" + this.name + "]";
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageConnector other = (StorageConnector)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        return Objects.equals(this.pins, other.pins);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.pins);
        return result;
    }
}

