/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.pins;

import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.storage.StorageValue;
import com.nxp.swtools.provider.configuration.storage.pins.StorageConnector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persist;

@NonNullByDefault
@Root(strict=false, name="expansion_header")
public class StorageExpansionHeader {
    @Attribute(name="id", required=true)
    protected String id;
    @Attribute(name="name", required=true)
    protected String name;
    @ElementList(name="options", required=false)
    @Nullable
    private @ElementList(name="options", required=false) @Nullable List<StorageValue> options;
    private Map<String, Object> optionsMap = new HashMap<String, Object>();
    @ElementList(name="connectors", entry="connector", required=false)
    @Nullable
    protected @ElementList(name="connectors", entry="connector", required=false) @Nullable ArrayList<StorageConnector> connectors;
    private boolean definedInBoardOrKit = false;
    private boolean definedByUser = false;
    private boolean definedInKit = false;
    public static final String CONNECTIONS_AND_LABELS_LOCKED = "connectionsAndLabelsLocked";
    public static final Boolean CONNECTIONS_AND_LABELS_LOCKED_DEFAULT = Boolean.FALSE;

    StorageExpansionHeader() {
        this.id = "";
        this.name = "";
    }

    public StorageExpansionHeader(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getOptionsMap() {
        return this.optionsMap;
    }

    @Commit
    public void build() {
        this.optionsMap.clear();
        if (this.options != null) {
            for (StorageValue option : this.options) {
                if (!option.getKey().equals(CONNECTIONS_AND_LABELS_LOCKED)) continue;
                this.optionsMap.put(CONNECTIONS_AND_LABELS_LOCKED, Boolean.valueOf(option.getValue()));
            }
        }
    }

    @Persist
    public void prepare() {
        this.options = this.optionsMap.isEmpty() ? null : this.optionsMap.entrySet().stream().map(x -> new StorageValue((String)x.getKey(), x.getValue().toString())).collect(Collectors.toList());
    }

    public List<StorageConnector> getConnectors() {
        return this.connectors != null ? this.connectors : Collections.emptyList();
    }

    public void setConnectors(@Nullable ArrayList<StorageConnector> connectors) {
        this.connectors = connectors;
    }

    public boolean isDefinedByUser() {
        return this.definedByUser;
    }

    public void setDefinedByUser(boolean definedByUser) {
        this.definedByUser = definedByUser;
    }

    public boolean isDefinedInBoardOrKit() {
        return this.definedInBoardOrKit;
    }

    public void setDefinedInBoardOrKit(boolean definedInBoardOrKit) {
        this.definedInBoardOrKit = definedInBoardOrKit;
    }

    public boolean isDefinedInKit() {
        return this.definedInKit;
    }

    public void setDefinedInKit(boolean definedInKit) {
        this.definedInKit = definedInKit;
    }

    public String toString() {
        return "StorageExpansionHeader [id=" + this.id + ", name=" + this.name + "]";
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageExpansionHeader other = (StorageExpansionHeader)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!Objects.equals(this.connectors, other.connectors)) {
            return false;
        }
        if (this.definedByUser != other.definedByUser) {
            return false;
        }
        if (this.definedInBoardOrKit != other.definedInBoardOrKit) {
            return false;
        }
        if (this.definedInKit != other.definedInKit) {
            return false;
        }
        return Objects.equals(this.options, other.options);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.connectors);
        result = 31 * result + (this.definedByUser ? 1231 : 1237);
        result = 31 * result + (this.definedInBoardOrKit ? 1231 : 1237);
        result = 31 * result + (this.definedInKit ? 1231 : 1237);
        result = 31 * result + Objects.hashCode(this.options);
        return result;
    }
}

