/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.pins;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.storage.pins.StorageExternalUserSignal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@NonNullByDefault
@Root(strict=false, name="external_user_signals")
public class StorageExternalUserSignals {
    @ElementList(name="routingDetailsColumns", entry="column", required=false)
    @Nullable
    protected @ElementList(name="routingDetailsColumns", entry="column", required=false) @Nullable ArrayList<@NonNull String> routingDetailsColumns = null;
    @ElementList(name="properties", entry="property", required=false)
    @Nullable
    protected @ElementList(name="properties", entry="property", required=false) @Nullable ArrayList<String> properties = null;
    @ElementList(name="signals", entry="external_user_signal", required=false)
    @Nullable
    protected @ElementList(name="signals", entry="external_user_signal", required=false) @Nullable ArrayList<StorageExternalUserSignal> signals = null;

    public String toString() {
        return "StorageExternalUserSignals [properties=" + this.properties + ", signals=" + this.signals + "]";
    }

    public List<@NonNull String> getRoutingDetailsColumns() {
        if (this.routingDetailsColumns != null) {
            return this.routingDetailsColumns;
        }
        return Collections.emptyList();
    }

    public void setRoutingDetailsColumns(ArrayList<String> routingDetailsColumns) {
        this.routingDetailsColumns = routingDetailsColumns;
    }

    public synchronized List<String> getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        return Collections.emptyList();
    }

    public synchronized void setProperties(ArrayList<String> properties) {
        this.properties = properties;
    }

    public synchronized List<StorageExternalUserSignal> getSignals() {
        if (this.signals != null) {
            return this.signals;
        }
        return Collections.emptyList();
    }

    public synchronized void setSignals(ArrayList<StorageExternalUserSignal> signals) {
        this.signals = signals;
    }

    public synchronized void addSignal(StorageExternalUserSignal signal) {
        if (this.signals != null) {
            this.signals.add(signal);
        } else {
            this.signals = new ArrayList();
            this.signals.add(signal);
        }
    }

    public synchronized void removeSignal(StorageExternalUserSignal signal) {
        ArrayList<StorageExternalUserSignal> signalsLoc = this.signals;
        if (signalsLoc != null) {
            signalsLoc.remove(signal);
            if (signalsLoc.isEmpty()) {
                this.signals = null;
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.signals == null && this.properties == null;
    }

    public synchronized void addProperty(String property) {
        if (this.properties != null) {
            this.properties.add(property);
        } else {
            this.properties = new ArrayList();
            this.properties.add(property);
        }
    }

    public synchronized void removeProperty(String column) {
        ArrayList<String> propertiesLoc = this.properties;
        if (propertiesLoc != null) {
            propertiesLoc.remove(column);
            if (propertiesLoc.isEmpty()) {
                this.properties = null;
            }
        }
    }

    public synchronized void renameProperty(String oldName, String newName) {
        int index;
        ArrayList<String> propertiesLoc = this.properties;
        if (propertiesLoc != null && (index = propertiesLoc.indexOf(oldName)) >= 0) {
            propertiesLoc.remove(index);
            propertiesLoc.add(index, newName);
        }
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageExternalUserSignals other = (StorageExternalUserSignals)obj;
        if (!Objects.equals(this.properties, other.properties)) {
            return false;
        }
        return Objects.equals(this.signals, other.signals);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.properties);
        result = 31 * result + Objects.hashCode(this.signals);
        return result;
    }

    @Commit
    public void validate() {
        ArrayList<@NonNull String> routingDetailsColumnsLoc = this.routingDetailsColumns;
        if (routingDetailsColumnsLoc == null) {
            this.routingDetailsColumns = new ArrayList();
        } else {
            int i = 0;
            while (i < routingDetailsColumnsLoc.size()) {
                if (routingDetailsColumnsLoc.get(i) == null) {
                    routingDetailsColumnsLoc.set(i, "");
                }
                ++i;
            }
        }
    }
}

