/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.yaml.IYamlConvertible;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableHelper;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeGenericRdcTemplateConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(strict=false)
public abstract class AStorageTeeGenericRdcCheckerConfig
implements IYamlConvertible {
    @Attribute(name="checker_id", required=true)
    protected String checkerId = "";
    @Attribute(name="using_global_templates", required=false)
    @Nullable
    protected @Attribute(name="using_global_templates", required=false) @Nullable Boolean usingGlobalTemplates;
    @ElementList(name="access_templates", entry="template", type=StorageTeeGenericRdcTemplateConfig.class, inline=false, required=false)
    @Nullable
    protected @ElementList(name="access_templates", entry="template", type=StorageTeeGenericRdcTemplateConfig.class, inline=false, required=false) @Nullable ArrayList<StorageTeeGenericRdcTemplateConfig> templates;

    public AStorageTeeGenericRdcCheckerConfig() {
    }

    public AStorageTeeGenericRdcCheckerConfig(String checkerId, boolean usingGlobalTemplates) {
        this.checkerId = checkerId;
        this.usingGlobalTemplates = usingGlobalTemplates;
    }

    public String getCheckerId() {
        return this.checkerId;
    }

    public void setCheckerId(String checkerId) {
        this.checkerId = checkerId;
    }

    public boolean getUsingGlobalTemplates() {
        return this.usingGlobalTemplates != null ? this.usingGlobalTemplates : false;
    }

    public void setUsingGlobalTemplates(boolean usingGlobalTemplates) {
        this.usingGlobalTemplates = usingGlobalTemplates;
    }

    public @Nullable StorageTeeGenericRdcTemplateConfig findTemplate(String id) {
        if (this.templates != null) {
            for (StorageTeeGenericRdcTemplateConfig template : this.templates) {
                if (!Objects.equals(template.getId(), id)) continue;
                return template;
            }
        }
        return null;
    }

    public List<StorageTeeGenericRdcTemplateConfig> getTemplates() {
        return this.templates != null ? this.templates : Collections.emptyList();
    }

    public void setTemplates(List<StorageTeeGenericRdcTemplateConfig> templates) {
        this.templates = !templates.isEmpty() ? new ArrayList<StorageTeeGenericRdcTemplateConfig>(templates) : null;
    }

    protected abstract String getYamlId();

    public final void fillYamlStorable(@NonNull IYamlStorable yaml) {
        ArrayList<IYamlStorable> storable = new ArrayList<IYamlStorable>();
        storable.add((IYamlStorable)new YamlStorableValue("checker_id", this.checkerId));
        if (this.usingGlobalTemplates != null) {
            storable.add((IYamlStorable)new YamlStorableValue("using_global_templates", this.usingGlobalTemplates.toString()));
        }
        this.addUnderlyingYaml(storable);
        ArrayList<StorageTeeGenericRdcTemplateConfig> templatesLoc = this.templates;
        if (templatesLoc != null) {
            YamlStorableList templatesYaml = new YamlStorableList("access_templates", Boolean.FALSE);
            templatesLoc.forEach(each -> each.fillYamlStorable((IYamlStorable)templatesYaml));
            storable.add((IYamlStorable)templatesYaml);
        }
        yaml.addYamlChild((IYamlStorable)new YamlStorableList(this.getYamlId(), storable, Boolean.FALSE));
    }

    public final boolean updateFromYamlStorable(IYamlStorable yaml) {
        if (!yaml.getYamlId().equals(this.getYamlId())) {
            return false;
        }
        Collection children = YamlStorableHelper.getChildrenAndSkipMapLayer((IYamlStorable)yaml);
        boolean ok = true;
        for (IYamlStorable childYaml : children) {
            ok &= this.updatePropertyFromYaml(childYaml);
        }
        return ok;
    }

    protected boolean updatePropertyFromYaml(IYamlStorable yaml) {
        String yamlId = yaml.getYamlId();
        if (yaml instanceof YamlStorableValue) {
            if (yamlId.equals("checker_id")) {
                this.setCheckerId(yaml.getYamlValue());
                return true;
            }
            if (yamlId.equals("using_global_templates")) {
                this.setUsingGlobalTemplates(Boolean.parseBoolean(yaml.getYamlValue()));
                return true;
            }
        } else if (yaml instanceof YamlStorableList && yamlId.equals("access_templates")) {
            ArrayList<StorageTeeGenericRdcTemplateConfig> templatesFromYaml = new ArrayList<StorageTeeGenericRdcTemplateConfig>();
            Collection templatesYamls = YamlStorableHelper.getChildrenCheckIdAndSkipMapLayer((IYamlStorable)yaml, (String)"access_templates");
            Iterator iterator = templatesYamls.iterator();
            while (iterator.hasNext()) {
                StorageTeeGenericRdcTemplateConfig fromYaml = new StorageTeeGenericRdcTemplateConfig();
                IYamlStorable templateYaml = (IYamlStorable)iterator.next();
                if (!fromYaml.updateFromYamlStorable(templateYaml)) continue;
                templatesFromYaml.add(fromYaml);
            }
            this.setTemplates(templatesFromYaml);
            return true;
        }
        return false;
    }

    protected abstract void addUnderlyingYaml(List<IYamlStorable> var1);

    public int hashCode() {
        return Objects.hash(this.checkerId);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AStorageTeeGenericRdcCheckerConfig other = (AStorageTeeGenericRdcCheckerConfig)obj;
        return Objects.equals(this.checkerId, other.checkerId) && Objects.equals(this.usingGlobalTemplates, other.usingGlobalTemplates) && Objects.equals(this.templates, other.templates);
    }

    public String toString() {
        return String.format("%s [checkerId=%s, usingGlobalTemplates=%s, templates=%s]", AStorageTeeGenericRdcCheckerConfig.class.getSimpleName(), this.checkerId, this.usingGlobalTemplates, this.templates != null ? this.templates.subList(0, Math.min(this.templates.size(), 3)) : null);
    }
}

