/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableHelper;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeAhbsc;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeGenericRdcTemplateConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeMbcConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="ahbsc_rwx", strict=false)
public class StorageTeeAhbscRwx
extends StorageTeeAhbsc {
    public static final String AHBSC_RWX_ID = "ahbsc_rwx";
    @ElementList(name="access_templates", entry="template", type=StorageTeeGenericRdcTemplateConfig.class, inline=false, required=false, empty=true)
    @Nullable
    private @ElementList(name="access_templates", entry="template", type=StorageTeeGenericRdcTemplateConfig.class, inline=false, required=false, empty=true) @Nullable ArrayList<StorageTeeGenericRdcTemplateConfig> templates;
    @ElementList(name="mbcs", entry="mbc", type=StorageTeeMbcConfig.class, inline=false, required=false)
    private ArrayList<StorageTeeMbcConfig> mbcs = new ArrayList();

    public @Nullable List<StorageTeeGenericRdcTemplateConfig> getTemplates() {
        return this.templates;
    }

    public void setTemplates(@Nullable List<StorageTeeGenericRdcTemplateConfig> templates) {
        this.templates = (ArrayList)CollectionsUtils.copyOfListOrNull(templates);
    }

    public @Nullable StorageTeeMbcConfig findMbcConfig(String checkerId) {
        for (StorageTeeMbcConfig mbc : this.mbcs) {
            if (!Objects.equals(mbc.getCheckerId(), checkerId)) continue;
            return mbc;
        }
        return null;
    }

    public List<StorageTeeMbcConfig> getMbcConfigs() {
        return this.mbcs;
    }

    public void setMbcConfigs(List<StorageTeeMbcConfig> mbcs) {
        this.mbcs = new ArrayList<StorageTeeMbcConfig>(mbcs);
    }

    @Override
    protected String getYamlId() {
        return AHBSC_RWX_ID;
    }

    @Override
    protected void saveToYaml(YamlStorableList<IYamlStorable> yamlStorable) {
        YamlStorableList mbcsYaml = new YamlStorableList("mbcs", Boolean.FALSE);
        this.mbcs.forEach(each -> each.fillYamlStorable((IYamlStorable)mbcsYaml));
        yamlStorable.addYamlChild((IYamlStorable)mbcsYaml);
    }

    @Override
    protected void loadFromYaml(Collection<IYamlStorable> yamlChildren) {
        ArrayList<StorageTeeGenericRdcTemplateConfig> templatesLoc = new ArrayList<StorageTeeGenericRdcTemplateConfig>();
        ArrayList<StorageTeeMbcConfig> mbcsLoc = new ArrayList<StorageTeeMbcConfig>();
        for (IYamlStorable childYaml : yamlChildren) {
            String yamlId = childYaml.getYamlId();
            if (!(childYaml instanceof YamlStorableList)) continue;
            if (yamlId.equals("access_templates")) {
                ArrayList<StorageTeeGenericRdcTemplateConfig> templatesFromYaml = new ArrayList<StorageTeeGenericRdcTemplateConfig>();
                for (IYamlStorable templateYaml : CollectionsUtils.safeCollection((Collection)childYaml.getYamlChildren())) {
                    StorageTeeGenericRdcTemplateConfig config;
                    if (templateYaml instanceof YamlStorableList) {
                        templateYaml = YamlStorableHelper.skipMapLayer((YamlStorableList)((YamlStorableList)templateYaml), (String)"template");
                    }
                    if (!(config = new StorageTeeGenericRdcTemplateConfig()).updateFromYamlStorable(templateYaml)) continue;
                    templatesFromYaml.add(config);
                }
                templatesLoc = templatesFromYaml;
                continue;
            }
            if (!yamlId.equals("mbcs")) continue;
            ArrayList<StorageTeeMbcConfig> mbcsFromYaml = new ArrayList<StorageTeeMbcConfig>();
            Collection mbcsYamls = YamlStorableHelper.getChildrenCheckIdAndSkipMapLayer((IYamlStorable)childYaml, (String)"mbcs");
            Iterator iterator = mbcsYamls.iterator();
            while (iterator.hasNext()) {
                StorageTeeMbcConfig config = new StorageTeeMbcConfig();
                IYamlStorable mbcYaml = (IYamlStorable)iterator.next();
                if (!config.updateFromYamlStorable(mbcYaml)) continue;
                mbcsFromYaml.add(config);
            }
            mbcsLoc = mbcsFromYaml;
        }
        this.setTemplates(templatesLoc);
        this.setMbcConfigs(mbcsLoc);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(this.templates, this.mbcs);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        StorageTeeAhbscRwx other = (StorageTeeAhbscRwx)obj;
        return Objects.equals(this.templates, other.templates) && Objects.equals(this.mbcs, other.mbcs);
    }
}

