/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.features;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.features.Feature;
import com.nxp.swtools.provider.features.IFeatureSet;
import com.nxp.swtools.provider.features.ModuleSpecific;
import com.nxp.swtools.provider.features.SocSpecific;
import com.nxp.swtools.provider.features.Specific;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementListUnion;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.core.Validate;

@Root(name="sdk_features", strict=false)
public class SdkFeatures
extends Specific
implements IFeatureSet {
    @ElementListUnion(value={@ElementList(entry="module_specific", inline=true, type=ModuleSpecific.class), @ElementList(entry="soc_specific", inline=true, type=SocSpecific.class)})
    @NonNull
    private @ElementListUnion(value={@ElementList(entry="module_specific", inline=true, type=ModuleSpecific.class), @ElementList(entry="soc_specific", inline=true, type=SocSpecific.class)}) @ElementList(entry="module_specific", inline=true, type=ModuleSpecific.class) @ElementList(entry="soc_specific", inline=true, type=SocSpecific.class) @NonNull List<@NonNull IFeatureSet> featureSets;
    @Attribute(name="prefix")
    @NonNull
    private @Attribute(name="prefix") @NonNull String prefix = "";
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(SdkFeatures.class);
    @NonNull
    private @NonNull Set<@NonNull String> cores = new LinkedHashSet<String>();
    @NonNull
    private @NonNull Map<Feature, Set<@NonNull String>> coresByFeature = new LinkedHashMap<Feature, Set<String>>();
    @NonNull
    private Map<String, Feature> featureByName = new LinkedHashMap<String, Feature>();
    @NonNull
    private @NonNull Set<@NonNull Feature> features = new LinkedHashSet<Feature>();
    @NonNull
    private @NonNull Map<@NonNull String, @NonNull ModuleSpecific> moduleFeatures = new LinkedHashMap<String, ModuleSpecific>();
    @NonNull
    private @NonNull Set<@NonNull String> parts = new LinkedHashSet<String>();
    @NonNull
    private @NonNull Map<Feature, Set<@NonNull String>> partsByFeature = new LinkedHashMap<Feature, Set<String>>();
    @NonNull
    private @NonNull Set<@NonNull String> periphs = new LinkedHashSet<String>();
    @NonNull
    private @NonNull Map<Feature, Set<@NonNull String>> periphsByFeature = new LinkedHashMap<Feature, Set<String>>();
    @Nullable
    private SocSpecific socFeatures = null;

    public static @Nullable SdkFeatures read(@NonNull Path fileName) {
        Persister ser = new Persister();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream sdkFeatureInStr = UtilsDecryption.getFileInputStream((File)fileName.toFile());){
                return (SdkFeatures)ser.read(SdkFeatures.class, sdkFeatureInStr);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, String.format("[DATA] Failed to parse \"%1s\": %2s", fileName, e.getMessage()), e);
            return null;
        }
    }

    @Deprecated
    protected SdkFeatures() {
        this.featureSets = new ArrayList<IFeatureSet>();
    }

    @Commit
    public void commit() {
        SdkFeatures.commitCores(this.featureSets, this.cores, this.coresByFeature);
        SdkFeatures.commitFeatures(this.featureSets, this.features);
        SdkFeatures.commitParts(this.featureSets, this.parts, this.partsByFeature);
        SdkFeatures.commitPeriphs(this.featureSets, this.periphs, this.periphsByFeature);
        for (IFeatureSet iFeatureSet : this.featureSets) {
            if (iFeatureSet instanceof SocSpecific) {
                this.socFeatures = (SocSpecific)iFeatureSet;
                continue;
            }
            if (!(iFeatureSet instanceof ModuleSpecific)) continue;
            ModuleSpecific moduleInst = (ModuleSpecific)iFeatureSet;
            this.moduleFeatures.put(moduleInst.getId(), moduleInst);
        }
        for (Feature feature : this.getFeatures()) {
            this.featureByName.put(feature.getName(), feature);
        }
    }

    @Override
    public @Nullable Set<@NonNull String> getCores() {
        return this.cores;
    }

    @Override
    public @Nullable Set<@NonNull String> getCoresByFeature(@NonNull Feature f) {
        return this.coresByFeature.get(f);
    }

    public @Nullable Feature getFeatureByName(@NonNull String name) {
        return this.featureByName.get(name);
    }

    public @Nullable Feature getFeatureByName(@NonNull String name, @Nullable String part, @Nullable String core, @Nullable String periph) {
        for (Feature f : this.features) {
            Set<String> periphNames;
            Set<String> coreNames;
            Set<String> partNames;
            if (!f.getName().equals(name) || part != null && !part.isEmpty() && (partNames = this.getPartsByFeature(f)) != null && !partNames.contains(part) || core != null && !core.isEmpty() && (coreNames = this.getCoresByFeature(f)) != null && !coreNames.contains(core) || periph != null && !periph.isEmpty() && (periphNames = this.getPeriphsByFeature(f)) != null && !periphNames.contains(periph)) continue;
            return f;
        }
        return null;
    }

    @Override
    public @NonNull Set<@NonNull Feature> getFeatures() {
        return this.features;
    }

    public @NonNull Map<@NonNull String, @NonNull ModuleSpecific> getModuleFeatures() {
        return this.moduleFeatures;
    }

    @Override
    public @NonNull Set<@NonNull String> getParts() {
        return this.parts;
    }

    @Override
    public @Nullable Set<@NonNull String> getPartsByFeature(@NonNull Feature f) {
        return this.partsByFeature.get(f);
    }

    @Override
    public @Nullable Set<@NonNull String> getPeriphs() {
        return this.periphs;
    }

    @Override
    public @Nullable Set<@NonNull String> getPeriphsByFeature(@NonNull Feature f) {
        return this.periphsByFeature.get(f);
    }

    public @NonNull String getPrefix() {
        return this.prefix;
    }

    public @Nullable SocSpecific getSocFeatures() {
        return this.socFeatures;
    }

    public boolean hasFeature(@NonNull String name) {
        return this.getFeatureByName(name) != null;
    }

    public boolean hasFeature(@NonNull String name, @Nullable String part, @Nullable String core, @Nullable String periph) {
        return this.getFeatureByName(name, part, core, periph) != null;
    }

    public @NonNull String removePrefix(@NonNull String prefixedName) {
        if (prefixedName.startsWith(this.prefix)) {
            return prefixedName.substring(this.prefix.length());
        }
        return prefixedName;
    }

    @Validate
    public void validate() throws PersistenceException {
        SocSpecific first = null;
        HashSet<@NonNull String> mset = new HashSet<String>();
        for (IFeatureSet f : this.featureSets) {
            if (f instanceof SocSpecific) {
                SocSpecific soc = (SocSpecific)f;
                if (first != null) {
                    throw new PersistenceException("Superfluous SoC feature set: %1s", new Object[]{soc.getId()});
                }
                first = soc;
                continue;
            }
            if (!(f instanceof ModuleSpecific)) continue;
            ModuleSpecific m = (ModuleSpecific)f;
            if (mset.contains(m.getId())) {
                throw new PersistenceException("Duplicate module: %1s", new Object[]{m.getId()});
            }
            mset.add(m.getId());
        }
    }

    public @NonNull List<@NonNull IFeatureSet> getFeatureSets() {
        return this.featureSets;
    }

    public void mergeContent(@NonNull Map<@NonNull String, @NonNull SdkFeatures> sdkfeatures) {
        SocSpecific localSocFeature = this.socFeatures;
        for (Map.Entry<String, SdkFeatures> sdkFeatureEntry : sdkfeatures.entrySet()) {
            SdkFeatures sdkFeature = sdkFeatureEntry.getValue();
            if (!this.getPrefix().equals(sdkFeature.getPrefix())) {
                LOGGER.severe("[DATA] The found sdk features can't be merged because has a different prefix: " + sdkFeatureEntry.getKey());
                continue;
            }
            SdkFeatures.commitCores(sdkFeature.getFeatureSets(), this.cores, this.coresByFeature);
            SdkFeatures.commitFeatures(sdkFeature.getFeatureSets(), this.features);
            SdkFeatures.commitParts(sdkFeature.getFeatureSets(), this.parts, this.partsByFeature);
            SdkFeatures.commitPeriphs(sdkFeature.getFeatureSets(), this.periphs, this.periphsByFeature);
            for (IFeatureSet f : sdkFeature.getFeatureSets()) {
                if (f instanceof SocSpecific) {
                    SocSpecific socInst = (SocSpecific)f;
                    if (localSocFeature != null) {
                        if (!localSocFeature.getId().equals(socInst.getId())) continue;
                        localSocFeature.mergeContent(socInst);
                        continue;
                    }
                    this.socFeatures = localSocFeature = (SocSpecific)f;
                    continue;
                }
                if (!(f instanceof ModuleSpecific)) continue;
                ModuleSpecific moduleInst = (ModuleSpecific)f;
                ModuleSpecific prevModule = this.moduleFeatures.get(moduleInst.getId());
                if (prevModule != null) {
                    prevModule.mergeContent(moduleInst);
                    continue;
                }
                this.moduleFeatures.put(moduleInst.getId(), moduleInst);
            }
        }
    }
}

