/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.processors;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.zip.ZipUtils;
import com.nxp.swtools.configuration.PEConfiguration;
import com.nxp.swtools.expert.processordb.ConfigComponentApi;
import com.nxp.swtools.expert.processordb.IConfigComponentApi;
import com.nxp.swtools.expert.processordb.IConfigComponentInfo;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISWToolsDataSdkInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.kex.api.IBaseInfo;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.service.datalocation.Location;

public class DataPackage {
    public static final String PROPERTY_COMPONENTS = "components";
    public static final String PROPERTY_KITS = "kits";
    public static final String PROPERTY_BOARDS = "boards";
    public static final String PROPERTY_PROCESSORS = "processors";
    public static final String PROPERTY_DATA_VERSION = "data_version";
    public static final String PACKAGE_MANIFEST = "npidata.mf";
    public static final String[] LICENSE_DATA_FILES = new String[]{"ProductLicense.txt:License.txt", "DataSoftwareContentRegister.txt:SoftwareContentRegister.txt"};
    static final Logger LOGGER = LogManager.getLogger(DataPackage.class);

    private DataPackage() {
    }

    static Collection<String> getFilesAndDirsToExport(Collection<ISWToolsDataSdkInfo> dataToExport, File sourceBaseDir) {
        ArrayList<String> resultRelativePaths = new ArrayList<String>();
        for (ISWToolsDataSdkInfo obj : dataToExport) {
            if (obj instanceof ITemplateInfo) {
                resultRelativePaths.add(UtilsFile.getFilePath((String)((ITemplateInfo)obj).getRelFileName()));
                continue;
            }
            if (obj instanceof IProcessorMasterToolInfo) {
                resultRelativePaths.add(((IProcessorMasterToolInfo)obj).getSubDir());
                continue;
            }
            if (obj instanceof IConfigComponentInfo) {
                IConfigComponentInfo comp = (IConfigComponentInfo)obj;
                resultRelativePaths.add(sourceBaseDir.toPath().relativize(comp.getComponentDir().toPath()).toString());
                continue;
            }
            assert (false) : "Unsupported object to export";
        }
        File sourceBaseDirFinal = sourceBaseDir;
        dataToExport.stream().map(ISWToolsDataSdkInfo::getSdkVersion).distinct().filter(sdk -> new File(String.valueOf(sourceBaseDirFinal.getAbsolutePath()) + File.separator + sdk + "_info.xml").exists()).forEach(sdk -> {
            boolean bl = resultRelativePaths.add(String.valueOf(sdk) + "_info.xml");
        });
        File compatibilityFile = new File(String.valueOf(sourceBaseDir.getAbsolutePath()) + File.separator + "configuration");
        if (compatibilityFile.exists()) {
            resultRelativePaths.add("configuration");
        }
        return resultRelativePaths;
    }

    static void addManifestToZipFile(ZipOutputStream zipOut, Collection<? extends ISWToolsDataSdkInfo> dataToExport, Collection<IConfigComponentApi> componentsToExport) throws IOException {
        ZipEntry entry = new ZipEntry(PACKAGE_MANIFEST);
        zipOut.putNextEntry(entry);
        ArrayList<String> processors = new ArrayList<String>();
        ArrayList<String> boards = new ArrayList<String>();
        ArrayList<String> kits = new ArrayList<String>();
        Map<String, Collection<String>> components = componentsToExport.stream().collect(Collectors.toMap(IConfigComponentApi::getApiVersion, e -> e.getComponents().stream().map(IBaseInfo::getName).collect(Collectors.toList())));
        assert (components != null);
        for (ISWToolsDataSdkInfo iSWToolsDataSdkInfo : dataToExport) {
            if (iSWToolsDataSdkInfo instanceof ITemplateInfo) {
                ITemplateInfo templ = (ITemplateInfo)iSWToolsDataSdkInfo;
                if (templ.getTemplateType() == ITemplateInfo.TemplateType.ttBoard) {
                    boards.add(templ.getId());
                    continue;
                }
                kits.add(templ.getId());
                continue;
            }
            if (iSWToolsDataSdkInfo instanceof IProcessorMasterToolInfo) {
                IProcessorMasterToolInfo proc = (IProcessorMasterToolInfo)iSWToolsDataSdkInfo;
                processors.add(proc.getId());
                continue;
            }
            if (!(iSWToolsDataSdkInfo instanceof IConfigComponentInfo)) assert (false) : "Unsupported object to export" + Objects.toString(iSWToolsDataSdkInfo);
        }
        DataPackage.createManifest((OutputStream)zipOut, processors, boards, kits, components);
        zipOut.closeEntry();
    }

    public static void createManifest(OutputStream out, Collection<String> processors, Collection<String> boards, Collection<String> kits, Map<String, Collection<String>> components) throws IOException {
        Properties p = new Properties();
        p.setProperty(PROPERTY_DATA_VERSION, KExProcessorsProvider.getRestApiDataVersion());
        p.setProperty(PROPERTY_PROCESSORS, processors.stream().sorted().distinct().collect(Collectors.joining(",")));
        p.setProperty(PROPERTY_BOARDS, boards.stream().sorted().distinct().collect(Collectors.joining(",")));
        p.setProperty(PROPERTY_KITS, kits.stream().sorted().distinct().collect(Collectors.joining(",")));
        for (Map.Entry<String, Collection<String>> entry : components.entrySet()) {
            p.setProperty("components_" + entry.getKey(), entry.getValue().stream().sorted().distinct().collect(Collectors.joining(",")));
        }
        p.store(out, null);
    }

    @Deprecated
    public static void createManifest(OutputStream out, Collection<String> processors, Collection<String> boards, Collection<String> kits, Collection<String> components) throws IOException {
        HashMap<String, Collection<String>> componentsMap = new HashMap<String, Collection<String>>();
        componentsMap.put(KExProcessorsProvider.getRestApiDataVersion(), components);
        DataPackage.createManifest(out, processors, boards, kits, componentsMap);
    }

    public static @Nullable File findSystemFile(String relPath) {
        File sysDir;
        File file;
        Location location = Platform.getInstallLocation();
        if (location != null) {
            String loc = location.getURL().getPath();
            file = new File(String.valueOf(loc) + File.separator + relPath);
            if (file.exists()) {
                return file;
            }
            Path path = new Path(loc);
            file = new File(String.valueOf((path = path.removeLastSegments(1)).toString()) + File.separator + relPath);
            if (file.exists()) {
                return file;
            }
        }
        if ((file = new File(sysDir = new File(PEConfiguration.getSystemDirectory()), relPath)).exists()) {
            return file;
        }
        File sysDirUp = sysDir.getParentFile();
        if (sysDirUp != null && (file = new File(sysDirUp, relPath)).exists()) {
            return file;
        }
        return null;
    }

    public static void addLicenseSCR(ZipOutputStream zipOut) throws IOException {
        String[] stringArray = LICENSE_DATA_FILES;
        int n = LICENSE_DATA_FILES.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            String[] pair = file.split(":");
            if (pair.length == 2) {
                File f = DataPackage.findSystemFile(pair[0]);
                if (f != null && f.isFile()) {
                    ZipEntry entry = new ZipEntry(ZipUtils.fixZipPathEntry((String)pair[1]));
                    zipOut.putNextEntry(entry);
                    Files.copy(f.toPath(), zipOut);
                    zipOut.closeEntry();
                } else {
                    LOGGER.log(Level.SEVERE, "License file {0} not found", pair[0]);
                }
            } else {
                LOGGER.log(Level.SEVERE, "Wrong format of src:tgt of license file {0}", file);
                assert (false);
            }
            ++n2;
        }
    }

    public static @Nullable Properties getManifestAsproperties(File file, boolean archive) throws IOException {
        block55: {
            if (archive) {
                ZipEntry entry;
                Object var5_11;
                try {
                    Throwable throwable = null;
                    var5_11 = null;
                    try (ZipInputStream zip = new ZipInputStream(new FileInputStream(file));){
                        for (int cntr = 0; (entry = zip.getNextEntry()) != null && cntr < 5; ++cntr) {
                            if (!PACKAGE_MANIFEST.equals(entry.getName())) continue;
                            Properties properties = new Properties();
                            properties.load(zip);
                            return properties;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.getMessage());
                }
                try {
                    Throwable e = null;
                    var5_11 = null;
                    try (ZipFile zipFile = new ZipFile(file);){
                        Optional<ZipEntry> first = zipFile.stream().filter(p -> p.getName().matches(".*npidata.mf")).findFirst();
                        ZipEntry zipEntry = entry = first.isPresent() ? first.get() : null;
                        if (entry == null) break block55;
                        Properties properties = new Properties();
                        Throwable throwable = null;
                        Object var10_30 = null;
                        try (InputStream inputStream = zipFile.getInputStream(entry);){
                            if (inputStream != null) {
                                properties.load(inputStream);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                        return properties;
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.getMessage());
                }
            } else {
                Throwable throwable = null;
                Object var3_18 = null;
                try (Stream<java.nio.file.Path> walk = Files.walk(Paths.get(file.toURI()), 1, new FileVisitOption[0]);){
                    Optional<java.nio.file.Path> first = walk.filter(f -> PACKAGE_MANIFEST.equals(Objects.requireNonNull(f.getFileName()).toString())).findAny();
                    if (!first.isPresent()) break block55;
                    Properties properties = new Properties();
                    Throwable throwable4 = null;
                    Object var8_25 = null;
                    try (FileInputStream inputStream = new FileInputStream(first.get().toFile());){
                        properties.load(inputStream);
                    }
                    catch (Throwable throwable5) {
                        if (throwable4 == null) {
                            throwable4 = throwable5;
                        } else if (throwable4 != throwable5) {
                            throwable4.addSuppressed(throwable5);
                        }
                        throw throwable4;
                    }
                    return properties;
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean createDataPackage(ISupportedDerivativesForSwTools derivatives, OutputStream ous, Collection<ISWToolsDataSdkInfo> dataToExport, Collection<IConfigComponentApi> components, IProgressMonitor monitor) throws IOException {
        var5_5 = null;
        var6_7 = null;
        try {
            zipFile = new ZipOutputStream(ous);
            try {
                DataPackage.addManifestToZipFile(zipFile, dataToExport, components);
                DataPackage.addLicenseSCR(zipFile);
                dataDirs = DataPackage.getFilesAndDirsToExport(dataToExport, new File(derivatives.getDataDir()));
                subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)dataDirs.size());
                var11_12 = dataDirs.iterator();
                while (true) {
                    path = var11_12.next();
                    if (monitor.isCanceled()) {
                        return false;
                    }
                    ZipUtils.addFileToZipFile((ZipOutputStream)zipFile, (File)new File(derivatives.getDataDir()), (String)path);
                    subMon.worked(1);
                    break;
                }
            }
            finally {
                if (var11_12.hasNext()) ** continue;
                return true;
            }
        }
        catch (Throwable var6_8) {
            if (var5_5 == null) {
                var5_5 = var6_8;
                throw var5_5;
            }
            if (var5_5 == var6_8) throw var5_5;
            var5_5.addSuppressed(var6_8);
            throw var5_5;
        }
    }

    public static void copyData(Collection<ISWToolsDataSdkInfo> dataToImport, File sourceBaseDir, File targetBaseDir, IProgressMonitor monitor) throws IOException {
        Collection<String> dataDirs = DataPackage.getFilesAndDirsToExport(dataToImport, sourceBaseDir);
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)dataDirs.size());
        for (String path : dataDirs) {
            subMon.subTask(path);
            UtilsFile.copy((File)new File(sourceBaseDir, path), (File)new File(targetBaseDir, path), (boolean)true);
            subMon.worked(1);
        }
    }

    public static Collection<IConfigComponentInfo> getComponentsToUpgrade(Collection<IConfigComponentApi> components, ISupportedDerivativesForSwTools derivatives) {
        ArrayList<IConfigComponentInfo> result = new ArrayList<IConfigComponentInfo>();
        for (IConfigComponentApi api : components) {
            api.getComponents().stream().filter(it -> {
                IConfigComponentInfo localComponent = derivatives.getComponentById(it.getName(), it.getSdkVersion(), api.getApiVersion());
                return localComponent == null || KExProcessorsProvider.isVersionHigher(it.getVersion(), localComponent.getVersion());
            }).forEach(result::add);
        }
        return result;
    }

    public static Collection<IConfigComponentApi> getComponentsForData(ISupportedDerivativesForSwTools derivatives, Collection<ISWToolsDataSdkInfo> data) {
        Set dataSdkVersions = data.stream().map(ISWToolsDataSdkInfo::getSdkVersion).collect(Collectors.toSet());
        Set<@Nullable T> dataApiVersions = data.stream().filter(IProcessorMasterToolInfo.class::isInstance).map(IProcessorMasterToolInfo.class::cast).map(IProcessorMasterToolInfo::getFrozenApiVersion).filter(Objects::nonNull).collect(Collectors.toSet());
        dataApiVersions.add(derivatives.getBaseApiVersion());
        return derivatives.getAllComponentsApis().stream().filter(api -> dataApiVersions.contains(api.getApiVersion())).map(api -> new ConfigComponentApi(api.getApiVersion(), (Collection)api.getComponents().stream().filter(it -> dataSdkVersions.contains(it.getSdkVersion())).collect(Collectors.toList()))).collect(Collectors.toList());
    }
}

