/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.processors.impl;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.kex.api.IProcessorInfo;
import com.nxp.swtools.provider.processors.ISWToolsProcessorInfo;
import com.nxp.swtools.provider.processors.impl.SWToolsBaseInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class SWToolsProcessorInfo
extends SWToolsBaseInfo<IProcessorInfo>
implements ISWToolsProcessorInfo {
    Collection<@NonNull String> targetProducts;

    public SWToolsProcessorInfo(IProcessorInfo processorInfo, String sdkId, String sdkName, String version, String products) {
        super(processorInfo, sdkId, sdkName, version);
        this.targetProducts = products.isEmpty() ? CollectionsUtils.emptyList() : CollectionsUtils.unmodifiableList(Arrays.asList(products.split(",")));
    }

    public @NonNull String getId() {
        return UtilsText.safeString((String)this.processorInfo.getName());
    }

    public @NonNull String getSubDir() {
        assert (false);
        return "";
    }

    public @NonNull String getDefaultPartNumber() {
        assert (false);
        return "";
    }

    public @NonNull Collection<@NonNull String> getPartNumbers() {
        return CollectionsUtils.emptyList();
    }

    public @NonNull String getSeries() {
        return UtilsText.safeString((String)this.processorInfo.getSubFamily());
    }

    @Override
    public @NonNull IProcessorInfo getProcessorInfo() {
        return this.processorInfo;
    }

    public String toString() {
        return String.valueOf(this.processorInfo.getName()) + " " + this.getSdkVersion() + '/' + this.getSeries() + ": ";
    }

    public String getFamily() {
        return UtilsText.safeString((String)this.processorInfo.getFamily());
    }

    public @NonNull String getProducer() {
        assert (false) : "Should not be called";
        return "NXP";
    }

    public @Nullable String getFrozenApiVersion() {
        return this.processorInfo.getAttribute("sdk." + this.sdkId + ".redirect");
    }

    public @NonNull Collection<@NonNull String> getTargetProducts() {
        return this.targetProducts;
    }

    public @NonNull Collection<@NonNull String> getEnabledTools() {
        ArrayList<String> enabledTools = new ArrayList<String>();
        String tool_key_prefix = "sdk." + this.sdkId + ".tools.";
        for (String key : this.processorInfo.getAttributeKeys()) {
            if (!key.startsWith(tool_key_prefix) || !Boolean.parseBoolean(this.processorInfo.getAttribute(key))) continue;
            enabledTools.add(key.substring(tool_key_prefix.length()));
        }
        return enabledTools;
    }
}

