/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.core;

import com.nxp.s32ds.cle.runtime.migration.internal.core.Messages;
import com.nxp.s32ds.cle.runtime.migration.internal.core.MigrationCoreActivator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class MigrationsAssert {
    private MigrationsAssert() {
    }

    public static void assertIsOk(IStatus status) throws CoreException {
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public static void assertIsOk(Stream<IStatus> stream) throws CoreException {
        Optional<IStatus> fail = stream.filter(s -> !s.isOK()).findFirst();
        if (fail.isPresent()) {
            throw new CoreException(fail.get());
        }
    }

    public static IStatus propertyExpected(String propertyName) {
        return MigrationCoreActivator.getInstance().createError(NLS.bind((String)Messages.MigrationsAssert_property_0_expected, (Object)propertyName));
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static boolean isEmpty(List<?> l) {
        return l == null || l.isEmpty();
    }
}

