/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml;

import com.nxp.s32ds.cle.runtime.migration.internal.core.Messages;
import com.nxp.s32ds.cle.runtime.migration.internal.core.MigrationCoreActivator;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml.MigrationSource;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.xml.XmlSequence;
import com.nxp.s32ds.ext.orbit.jaxb.OrbitJAXBContextFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;

public class MigrationXmlParser {
    private static MigrationXmlParser INSTANCE;
    private static final String SCHEMA_PATH = "resources/schema/sequence.xsd";
    private final Unmarshaller unmarshaller;

    public static MigrationXmlParser getInstance() throws CoreException {
        if (INSTANCE == null) {
            try {
                INSTANCE = new MigrationXmlParser();
            }
            catch (IOException | JAXBException | SAXException e) {
                throw new CoreException(MigrationCoreActivator.getInstance().createError(Messages.MigrationXmlParser_cannot_create_migration_xml_parser, e));
            }
        }
        return INSTANCE;
    }

    private MigrationXmlParser() throws JAXBException, SAXException, IOException {
        JAXBContext context = OrbitJAXBContextFactory.createContext(XmlSequence.class);
        this.unmarshaller = context.createUnmarshaller();
        URL schemaUrl = MigrationCoreActivator.getInstance().getPathUrl(SCHEMA_PATH);
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream stream = schemaUrl.openStream();){
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(new StreamSource(stream));
            this.unmarshaller.setSchema(schema);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public XmlSequence parse(MigrationSource source) throws CoreException {
        try {
            Unmarshaller unmarshaller = this.unmarshaller;
            synchronized (unmarshaller) {
                Throwable throwable = null;
                Object var4_7 = null;
                try (InputStream inputStream = source.getInputStream();){
                    return (XmlSequence)this.unmarshaller.unmarshal((Source)new StreamSource(inputStream), XmlSequence.class).getValue();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException | JAXBException e) {
            Throwable linkedException;
            Throwable cause = e;
            if (e instanceof JAXBException && (linkedException = ((JAXBException)e).getLinkedException()) != null) {
                cause = linkedException;
            }
            throw new CoreException(MigrationCoreActivator.getInstance().createError(NLS.bind((String)Messages.MigrationXmlParser_cannot_parse_file_0_caused_by_1, (Object)source.getUID(), (Object)cause.getMessage()), cause));
        }
    }
}

