/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.debugger.internal.connections.registry;

import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnection;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionAccessor;
import com.nxp.s32ds.cle.runtime.debugger.internal.connections.registry.DebuggerConnectionDescriptorImpl;
import com.nxp.s32ds.ext.rcp.runtime.Extensions;
import com.nxp.s32ds.ext.rcp.runtime.RcpBundle;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class DebuggerConnectionsRegistryActivator
extends RcpBundle {
    public static final String BUNDLE_ID = "com.nxp.s32ds.cle.runtime.debugger.connections.registry";
    public static final String DEBUGGER_CONNECTION_EXTENSION_POINT = "debuggerConnection";
    public static final String DEBUGGER_CONNECTION_ELEMENT = "connection";
    public static final String DEBUGGER_CONNECTION_ACCESSOR_CLASS = "class";
    private static DebuggerConnectionsRegistryActivator INSTANCE;
    private static BundleContext context;
    private ServiceTracker<DebuggerConnection, DebuggerConnection> debuggerConnectionDevicesServiceTracker;
    private DebuggerConnection debuggerConnectionDevicesService;

    public static DebuggerConnectionsRegistryActivator getInstance() {
        return INSTANCE;
    }

    public String getBundleId() {
        return BUNDLE_ID;
    }

    public void start(BundleContext bc) throws Exception {
        super.start(bc);
        INSTANCE = this;
        context = bc;
        String debuggerUsbDevicesClassName = DebuggerConnection.class.getName();
        this.debuggerConnectionDevicesServiceTracker = new ServiceTracker(context, debuggerUsbDevicesClassName, null);
        this.debuggerConnectionDevicesServiceTracker.open();
        this.debuggerConnectionDevicesService = (DebuggerConnection)this.debuggerConnectionDevicesServiceTracker.getService();
        this.registerDebuggerConnectionDevices(this.debuggerConnectionDevicesService);
    }

    public void stop(BundleContext bc) throws Exception {
        super.stop(bc);
        this.debuggerConnectionDevicesServiceTracker.close();
        this.debuggerConnectionDevicesServiceTracker = null;
        this.debuggerConnectionDevicesService = null;
        INSTANCE = null;
        context = null;
    }

    private void registerDebuggerConnectionDevices(DebuggerConnection registry) {
        List connectionDeviceElements = Extensions.getConfigrationElements((String)BUNDLE_ID, (String)DEBUGGER_CONNECTION_EXTENSION_POINT, (String)DEBUGGER_CONNECTION_ELEMENT, (String[])new String[0]);
        for (IConfigurationElement element : connectionDeviceElements) {
            DebuggerConnectionDescriptorImpl descriptor = new DebuggerConnectionDescriptorImpl(element);
            DebuggerConnectionAccessor deviceAcessor = (DebuggerConnectionAccessor)Extensions.safeCreateExecutableExtension((IConfigurationElement)element, (String)DEBUGGER_CONNECTION_ACCESSOR_CLASS);
            if (deviceAcessor == null) {
                this.logError("Cannot find accessor for device descriptor with the name " + descriptor.getConnectionName());
            }
            registry.addDeviceDescriptor(descriptor, deviceAcessor);
        }
    }

    public DebuggerConnection getRegistry() {
        return this.debuggerConnectionDevicesService;
    }
}

