/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.dsf.memory;

import com.nxp.s32ds.cdt.internal.svd.SvdActivator;
import com.nxp.s32ds.cdt.internal.svd.dsf.memory.SvdDsfMemoryRange;
import com.nxp.s32ds.cdt.internal.svd.dsf.memory.SvdDsfMemoryRangeChains;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;

public class SvdDsfMemoryRangeChain
implements Cloneable {
    private final ListenerList<ChainChangeListener> listeners = new ListenerList(1);
    private final List<SvdDsfMemoryRange> ranges = new ArrayList<SvdDsfMemoryRange>();

    public SvdDsfMemoryRangeChain() {
    }

    private SvdDsfMemoryRangeChain(SvdDsfMemoryRangeChain chain) {
        this.ranges.addAll(chain.ranges);
    }

    public void addListener(ChainChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(ChainChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void fireChainChanged(ChainChangeType type) {
        for (ChainChangeListener listener : this.listeners) {
            try {
                listener.chainChanged(type);
            }
            catch (Exception e) {
                SvdActivator.getInstance().logError("Error during listener call.", e);
            }
        }
    }

    public boolean contains(SvdDsfMemoryRange range) {
        return this.getContainingRange(range) != null;
    }

    public void remove(SvdDsfMemoryRange range) {
        if (SvdDsfMemoryRangeChains.remove(this.ranges, range)) {
            this.fireChainChanged(ChainChangeType.REMOVE);
        }
    }

    public void add(SvdDsfMemoryRange range) {
        SvdDsfMemoryRangeChains.add(this.ranges, range);
        this.fireChainChanged(ChainChangeType.ADD);
    }

    public SvdDsfMemoryRange getContainingRange(SvdDsfMemoryRange range) {
        int nearestLessIndex = SvdDsfMemoryRangeChains.getNearestLessIndex(this.ranges, range);
        if (nearestLessIndex < 0) {
            return null;
        }
        SvdDsfMemoryRange nearestLess = this.ranges.get(nearestLessIndex);
        if (nearestLess.contains(range)) {
            return nearestLess;
        }
        return null;
    }

    public List<SvdDsfMemoryRange> getRanges() {
        return new ArrayList<SvdDsfMemoryRange>(this.ranges);
    }

    public SvdDsfMemoryRangeChain clone() {
        return new SvdDsfMemoryRangeChain(this);
    }

    public static interface ChainChangeListener {
        public void chainChanged(ChainChangeType var1);
    }

    public static enum ChainChangeType {
        ADD,
        REMOVE;

    }
}

