/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.parser.model;

import com.nxp.s32ds.cdt.internal.svd.Messages;
import com.nxp.s32ds.cdt.svd.parser.model.ParseRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;

public class DimIndexType {
    private static final String RANGE_SEPARATOR = "-";
    private static final String LIST_SEPARATOR = ",";
    private static final ThreadLocal<Matcher> THREAD_LOCAL = ThreadLocal.withInitial(() -> Pattern.compile("([0-9]+\\-[0-9]+)|([A-Z]\\-[A-Z])|([_0-9a-zA-Z]+(,\\s*[_0-9a-zA-Z]+)+)").matcher(""));
    private final List<String> indexes;

    public DimIndexType(List<String> indexes) {
        this.indexes = Collections.unmodifiableList(indexes);
    }

    public List<String> getIndexes() {
        return this.indexes;
    }

    public static DimIndexType parseDimIndexType(String value) {
        if (value == null || value.trim().isEmpty()) {
            throw new ParseRuntimeException(NLS.bind((String)Messages._0_value_should_not_be_empty, (Object)DimIndexType.class.getSimpleName()));
        }
        Matcher matcher = THREAD_LOCAL.get();
        matcher.reset(value);
        if (!matcher.matches()) {
            throw new ParseRuntimeException(NLS.bind((String)Messages._0_value_should_match_1, (Object)DimIndexType.class.getSimpleName(), (Object)"[0-9]+\\-[0-9]+|[A-Z]-[A-Z]|[_0-9a-zA-Z]+(,\\s*[_0-9a-zA-Z]+)+"));
        }
        ArrayList<String> indexes = new ArrayList<String>();
        DimIndexType.extractNumberRange(indexes, matcher.group(1));
        DimIndexType.extractCharRange(indexes, matcher.group(2));
        DimIndexType.extractList(indexes, matcher.group(3));
        return new DimIndexType(indexes);
    }

    private static void extractNumberRange(List<String> indexes, String value) {
        if (value == null) {
            return;
        }
        String[] range = value.split(RANGE_SEPARATOR);
        int start = Integer.parseInt(range[0]);
        int end = Integer.parseInt(range[1]);
        DimIndexType.checkRange(start, end);
        int i = start;
        while (i <= end) {
            indexes.add(String.valueOf(i));
            ++i;
        }
    }

    private static void extractCharRange(List<String> indexes, String value) {
        if (value == null) {
            return;
        }
        String[] range = value.split(RANGE_SEPARATOR);
        char start = range[0].charAt(0);
        char end = range[1].charAt(0);
        DimIndexType.checkRange(start, end);
        char c = start;
        while (c <= end) {
            indexes.add(String.valueOf(c));
            c = (char)(c + '\u0001');
        }
    }

    private static void extractList(List<String> indexes, String value) {
        if (value == null) {
            return;
        }
        String[] indices = value.split(LIST_SEPARATOR);
        int i = 0;
        while (i < indices.length) {
            indexes.add(indices[i].trim());
            ++i;
        }
    }

    private static void checkRange(int start, int end) {
        if (end < start) {
            throw new ParseRuntimeException(Messages.DimIndexType_range_start_should_be_less_than_range_end);
        }
    }

    public String printDimIndexType() {
        return String.join((CharSequence)LIST_SEPARATOR, this.indexes);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.indexes == null ? 0 : this.indexes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DimIndexType other = (DimIndexType)obj;
        return !(this.indexes == null ? other.indexes != null : !this.indexes.equals(other.indexes));
    }

    public String toString() {
        return this.printDimIndexType();
    }
}

