/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.core;

import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionAccessor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnections;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DeviceConnection;
import com.nxp.s32ds.debug.ide.core.DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.internal.core.HostValidator;
import java.io.File;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;

public class DebuggerUtils {
    private static final String VALUE_EMPTY = "";

    public static String substitute(String pathVariable) {
        try {
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(pathVariable);
        }
        catch (CoreException e) {
            DebuggerCoreActivator.getInstance().log(e.getStatus());
            return VALUE_EMPTY;
        }
    }

    public static IBinary[] getProjectBinaries(ICProject cproject) throws CModelException {
        return cproject != null ? cproject.getBinaryContainer().getBinaries() : null;
    }

    public static String getProjectBinary(ICProject cProject) throws CModelException {
        String binary = VALUE_EMPTY;
        IBinary[] bins = DebuggerUtils.getProjectBinaries(cProject);
        if (bins != null && bins.length > 0) {
            binary = bins[0].getResource().getProjectRelativePath().toString();
        }
        return binary;
    }

    public static String getAbsoluteBinaryPathByProjectName(String projectName, String binaryPath) {
        if (binaryPath == null) {
            return null;
        }
        if (projectName == null || projectName.isEmpty() || binaryPath.isEmpty()) {
            return binaryPath;
        }
        try {
            IPath projectLocation = CoreModel.getDefault().getCModel().getCProject(projectName).getProject().getLocation();
            return new File(binaryPath).exists() || projectLocation == null ? binaryPath : projectLocation.append(binaryPath).toString();
        }
        catch (Exception exception) {
            return binaryPath;
        }
    }

    public static String getConnectionStringForDeviceConnection(String connectionData) {
        if (connectionData == null || connectionData.isEmpty()) {
            return null;
        }
        DeviceConnection deviceConnection = DeviceConnection.createFromFullConnectionString((String)connectionData);
        if (deviceConnection != null) {
            String deviceConnectionId = deviceConnection.getDeviceConnectionId();
            DebuggerConnectionAccessor devAccessor = DebuggerConnections.getDebuggerConnectionAccessorByConnectionName((String)deviceConnectionId);
            DebuggerConnectionDescriptor connectionDescriptor = DebuggerConnections.getDebuggerConnectionDescriptorByConnectionName((String)deviceConnectionId);
            if (devAccessor != null && connectionDescriptor != null) {
                return devAccessor.getConnectionString(connectionDescriptor, deviceConnection);
            }
        }
        return null;
    }

    public static boolean validateIpOrHost(String addressStr) {
        return HostValidator.validateIPAddress(addressStr) || HostValidator.validateHostName(addressStr) || HostValidator.validateDomainName(addressStr);
    }

    public static boolean validateIp(String addressStr) {
        return HostValidator.validateIPAddress(addressStr);
    }

    public static String generateProcessName(ILaunchConfiguration lc, String processLabel) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(lc.getName());
        String type = null;
        try {
            type = lc.getType().getName();
        }
        catch (CoreException ex) {
            DebuggerCoreActivator.getInstance().log(ex.getStatus());
        }
        buffer.append(" ");
        if (type != null) {
            buffer.append("[");
            buffer.append(type);
            buffer.append("] ");
        }
        buffer.append(processLabel);
        return buffer.toString();
    }
}

