/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.common.uct.validation;

import com.nxp.swtools.common.uct.utils.Messages;
import com.nxp.swtools.common.uct.validation.ATextfieldWidthValidator;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.common.utils.number.NumberFormatter;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Status;

public class HexadecimalAddressValidator
extends ATextfieldWidthValidator {
    protected boolean isZeroValueValid = true;
    protected static final Logger LOGGER = LogManager.getLogger(HexadecimalAddressValidator.class);
    protected boolean formatValid = true;

    public HexadecimalAddressValidator(int width) {
        super(width);
        this.isZeroValueValid = true;
    }

    public HexadecimalAddressValidator(int width, boolean isZeroValueValid) {
        super(width);
        this.isZeroValueValid = isZeroValueValid;
    }

    @Override
    public Status validate(String pluginId, String value) {
        Status hexStatus = this.isValidHexadecimal(pluginId, value);
        if (hexStatus.isOK()) {
            return hexStatus;
        }
        if (!hexStatus.isOK() && NumberFormatValidator.isValidHexadecimal((String)value)) {
            return hexStatus;
        }
        return hexStatus;
    }

    public Status isValidHexadecimal(String pluginId, String value) {
        Status status = new Status(0, pluginId, "");
        long longValue = NumberFormatValidator.getLongValueFromString((String)value);
        if (NumberFormatValidator.isValidHexadecimal((String)value)) {
            this.formatValid = true;
            if (NumberFormatter.hexadecimalToDec((String)value) > NumberFormatValidator.getHighDecimalLimit((long)this.getWidth())) {
                status = new Status(4, pluginId, Messages.InvalidWidthValue);
            } else if (!this.isZeroValueValid && longValue == 0L) {
                status = new Status(4, pluginId, Messages.InvalidTextfieldValueZero);
            }
        } else {
            status = new Status(4, pluginId, Messages.HexadecimalInvalidValue);
            if (!NumberFormatValidator.isValidDecimal((String)value)) {
                this.formatValid = false;
            }
        }
        return status;
    }

    @Override
    public boolean isFormatValid() {
        return this.formatValid;
    }
}

