/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponent;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponentInstance;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.utils.ConfigurationUtils;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StorageUtils {
    protected static final Logger LOGGER = LogManager.getLogger(StorageUtils.class);

    public static @Nullable StoragePeriphsTool getToolStorage(File presetMex) {
        ISharedConfiguration configFromFile = ConfigurationUtils.loadConfigurationFromFile((File)presetMex);
        if (configFromFile == null) {
            LOGGER.log(Level.SEVERE, "Cannot reset to processor default configuration. Could not load configuration from file \"{0}\".", presetMex.getAbsolutePath());
            return null;
        }
        return configFromFile.getTools().getPeripherals();
    }

    public static List<StoragePeriphsComponent> getComponentsFromStorage(StoragePeriphsTool toolStorage) {
        return toolStorage.getComponents();
    }

    public static List<StoragePeriphsComponentInstance> getComponentInstancesFromStorage(StoragePeriphsTool toolStorage) {
        return (List)toolStorage.getFuncGroups().stream().flatMap(x -> x.getInstances().stream()).collect(CollectorsUtils.toList());
    }

    private StorageUtils() {
    }
}

