/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller.generation;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.provider.configuration.sources.ISourceFile;
import com.nxp.swtools.provider.configuration.sources.ISourceFileGenerationStatus;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProvider;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.wizards.exportWizard.AExportWizard;
import java.util.Collection;

public class PeripheralsSourceCodeGeneration
implements ISourceFileProvider {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public ISourceFileGenerationStatus getGeneratedFiles(String coreId, Collection<ISourceFile> generatedFiles) {
        ScriptResult scriptResult;
        Controller controller = Controller.getInstance();
        AExportWizard.GenerationResult generationResult = controller.getGenerationResult(coreId);
        ScriptResult scriptResult2 = scriptResult = controller.isCodeDirty() ? controller.waitAndGetGeneratedCode() : controller.getGeneratedCode();
        if (scriptResult != null) {
            String errors;
            if (scriptResult.isFailed()) {
                return SourceFileProviderFactory.buildGenerationStatus((ISourceFileGenerationStatus.GenerationStatus)ISourceFileGenerationStatus.GenerationStatus.FATAL, (String)generationResult.failReason);
            }
            @NonNull Collection sourceFiles = generationResult.getGeneratedSourceFiles();
            if (sourceFiles != null) {
                generatedFiles.addAll(sourceFiles);
            }
            if (!(errors = scriptResult.getErrors()).isEmpty()) {
                return SourceFileProviderFactory.buildGenerationStatus((ISourceFileGenerationStatus.GenerationStatus)ISourceFileGenerationStatus.GenerationStatus.ERRORS, (String)errors);
            }
            String warnings = scriptResult.getWarnings();
            if (!warnings.isEmpty()) {
                return SourceFileProviderFactory.buildGenerationStatus((ISourceFileGenerationStatus.GenerationStatus)ISourceFileGenerationStatus.GenerationStatus.WARNING, (String)warnings);
            }
        }
        return SourceFileProviderFactory.buildGenerationOKStatus();
    }
}

