/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller.migration;

import com.nxp.swtools.common.utils.Nullable;
import java.util.Arrays;
import java.util.Objects;

public class MigrationReportData {
    private String stringContent = "";
    private int[] messageCount = new int[3];
    private int type = 0;
    private static final int ERROR_MESSAGES_INDEX = 0;
    private static final int WARNING_MESSAGES_INDEX = 1;
    private static final int INFO_MESSAGES_INDEX = 2;
    public static final int FILE = 4;
    public static final int CONTENT = 2;

    public MigrationReportData(int type, String string, int[] messagesCount) {
        this.type = type;
        this.stringContent = string;
        this.messageCount = messagesCount;
    }

    public int getType() {
        return this.type;
    }

    public boolean isContent() {
        return (this.type & 2) != 0;
    }

    public boolean isFile() {
        return (this.type & 4) != 0;
    }

    public String getStringContent() {
        return this.stringContent;
    }

    public int getErrorsCount() {
        return this.messageCount[0];
    }

    public int getWarningsCount() {
        return this.messageCount[1];
    }

    public int getInfosCount() {
        return this.messageCount[2];
    }

    public int[] getMessageCount() {
        return this.messageCount;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrationReportData)) {
            return false;
        }
        MigrationReportData other = (MigrationReportData)obj;
        if (this.type != other.type) {
            return false;
        }
        if (!Objects.equals(this.stringContent, other.stringContent)) {
            return false;
        }
        return Arrays.equals(this.messageCount, other.messageCount);
    }

    public int hashCode() {
        return Objects.hash(this.stringContent, this.messageCount) + 31 * this.type;
    }

    public String toString() {
        return String.valueOf(MigrationReportData.class.getSimpleName()) + "[" + this.stringContent + ", " + "message count: " + Arrays.toString(this.messageCount) + "]";
    }
}

