/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller.migration;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.periphs.controller.ConfigurationComponentUtils;
import com.nxp.swtools.periphs.controller.MigrationHelper;
import com.nxp.swtools.periphs.controller.MigrationMessage;
import com.nxp.swtools.periphs.controller.migration.MigrationReportData;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.utils.support.markdown.MarkDownSupport;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MigrationReportGenerator {
    private static final Logger LOGGER = LogManager.getLogger(MigrationReportGenerator.class);
    public static final String PATH_TO_REPORTS_FOLDER = UtilsText.safeString((String)UtilsFile.getFullWorkspacePath((String)Paths.get("${workspace_loc}", "migration_reports").toString()));
    private static String mainDocumentFragment = MigrationReportGenerator.getResource("/resources/migration_template/template.fragment");
    private static String styleFragment = MigrationReportGenerator.getResource("/resources/migration_template/style.fragment");
    private static String migrationBlockFragment = MigrationReportGenerator.getResource("/resources/migration_template/migration.fragment");
    private static String migrationRowBlockFragment = MigrationReportGenerator.getResource("/resources/migration_template/migration_row.fragment");

    public static MigrationReportData generateHTML(ISharedConfiguration configuration, MigrationMessage.ShowMode mode, String date, List<CollectionsUtils.Pair<IComponentInstanceConfig, IComponentInstanceConfig>> instancePairs) {
        int severeMessagesCounter = 0;
        int warningMessagesCounter = 0;
        int infoMessagesCounter = 0;
        String result = mainDocumentFragment.replace("{$style_fragment}", styleFragment);
        result = result.replace("{$date_time}", date);
        result = result.replace("{$mex_location}", UtilsText.safeString((String)configuration.getLocationOnDisk()));
        IMcuIdentification mcuIdentification = configuration.getCommonConfig().getMcuIdentification();
        result = result.replace("{$mcu}", mcuIdentification.getMcu());
        result = result.replace("{$mcu_package}", mcuIdentification.getPackage());
        result = result.replace("{$sdk_version}", mcuIdentification.getSdkVersion());
        StringBuilder migrations = new StringBuilder();
        for (CollectionsUtils.Pair<IComponentInstanceConfig, IComponentInstanceConfig> pair : instancePairs) {
            StringBuilder rows = new StringBuilder();
            IComponentInstanceConfig toInstance = (IComponentInstanceConfig)pair.getFirst();
            IComponentInstanceConfig fromInstance = (IComponentInstanceConfig)pair.getSecond();
            List<MigrationMessage> migrationMessages = MigrationHelper.collectMigrationMessages(toInstance, fromInstance);
            for (MigrationMessage message : migrationMessages) {
                if (!MigrationReportGenerator.shouldShow(mode, message.getShowMode())) continue;
                String row = migrationRowBlockFragment;
                MigrationMessage.Severity severity = message.getSeverity();
                switch (severity) {
                    case ERROR: {
                        ++severeMessagesCounter;
                        break;
                    }
                    case WARNING: {
                        ++warningMessagesCounter;
                        break;
                    }
                    default: {
                        ++infoMessagesCounter;
                    }
                }
                row = row.replace("{$severity}", severity.getCSSClass());
                row = row.replace("{$setting_path}", message.getPath());
                String markdown = MarkDownSupport.markDownToHtml((String)message.getMessage(), null);
                row = row.replace("{$migration_description}", markdown);
                rows.append(row);
            }
            String migration = migrationBlockFragment.replace("{$migration_row_fragments}", rows.toString());
            migration = migration.replace("{$original_component}", String.valueOf(fromInstance.getConfigurationComponentType()) + "(" + ConfigurationComponentUtils.buildDriverDependencyInfo(fromInstance.getConfigCompTypeId(), true) + ")");
            migration = migration.replace("{$replacement_component}", String.valueOf(toInstance.getConfigurationComponentType()) + "(" + ConfigurationComponentUtils.buildDriverDependencyInfo(toInstance.getConfigCompTypeId(), true) + ")");
            MigrationMessage componentMessage = MigrationHelper.getComponentMigrationMessage(toInstance, fromInstance);
            String message = componentMessage != null ? componentMessage.getMessage() : "";
            migration = migration.replace("{$component_migration_description}", message);
            migrations.append(migration);
        }
        result = result.replace("{$migration_fragments}", migrations.toString());
        return new MigrationReportData(2, result, new int[]{severeMessagesCounter, warningMessagesCounter, infoMessagesCounter});
    }

    public static @Nullable MigrationReportData createHtmlReport(ISharedConfiguration configuration, MigrationMessage.ShowMode mode, List<CollectionsUtils.Pair<IComponentInstanceConfig, IComponentInstanceConfig>> instancePairs) {
        boolean isTheReportsFolderCreated;
        String date = DateFormat.getDateTimeInstance().format(new Date());
        String fileName = String.valueOf(date.replaceAll("[\\ ,:]", "_")) + ".html";
        File folder = new File(PATH_TO_REPORTS_FOLDER);
        if (!folder.exists() && !(isTheReportsFolderCreated = folder.mkdir())) {
            LOGGER.log(Level.SEVERE, "[TOOL] Could not create the folder with reports: {0}", PATH_TO_REPORTS_FOLDER);
            return null;
        }
        File file = new File(folder, fileName);
        MigrationReportData data = MigrationReportGenerator.generateHTML(configuration, mode, date, instancePairs);
        String filePath = file.getAbsolutePath();
        if (UtilsFile.writeFile((String)filePath, (byte[])data.getStringContent().getBytes(StandardCharsets.UTF_8))) {
            LOGGER.log(Level.INFO, "[TOOL] Migration report location: {0}", filePath);
            return new MigrationReportData(4, filePath, data.getMessageCount());
        }
        return null;
    }

    public static boolean shouldShow(MigrationMessage.ShowMode mode, MigrationMessage.ShowMode messageMode) {
        if (messageMode == MigrationMessage.ShowMode.ALWAYS) {
            return true;
        }
        return mode == messageMode;
    }

    private MigrationReportGenerator() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getResource(String path) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream resource = MigrationReportGenerator.class.getResourceAsStream(path);){
                if (resource != null) return UtilsText.safeString((String)UtilsFile.readFileToString((InputStream)resource, (Charset)StandardCharsets.UTF_8, null));
                return "";
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception exception) {
            return "";
        }
    }
}

