/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek.controller;

import com.freescale.s32ds.debug.ka.osek.OsekPlugin;
import com.freescale.s32ds.debug.ka.osek.orti.model.OrtiImplementation;
import com.freescale.s32ds.debug.ka.osek.orti.model.OrtiImplementationManager;
import com.freescale.s32ds.debug.ka.osek.utils.OrtiImageResources;
import com.freescale.system.browser.model.OSAwarenessData;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class OSEKLabelProvider
implements ILabelProvider {
    private Image fOsekLabelImage;
    private static final String OSEK_LABEL_FORMAT = "Application:%1$s, Implementation:%2$s (%3$s)";

    public Image getImage(Object element) {
        if (this.fOsekLabelImage == null) {
            try {
                this.fOsekLabelImage = OrtiImageResources.GetImage(OrtiImageResources.ImageType.OsekLogo);
            }
            catch (Exception ex) {
                OsekPlugin.log(ex);
            }
        }
        return this.fOsekLabelImage;
    }

    public String getText(Object element) {
        String version = "Unknown";
        String implName = "Unknown";
        IRunControl.IExecutionDMContext context = null;
        if (element instanceof OSAwarenessData) {
            context = ((OSAwarenessData)element).getContext();
            OrtiImplementation ortii = OrtiImplementationManager.getDefault().getOrtiImpl(context);
            if (ortii != null) {
                version = ortii.getVersion();
                if (version == null || version.length() == 0) {
                    version = "Unknown";
                }
                if ((implName = ortii.getImplementationName()) == null || implName.length() == 0) {
                    implName = "Unknown";
                }
                return String.format(OSEK_LABEL_FORMAT, element.toString(), implName, version);
            }
        }
        return " ";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

