/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.jface;

import com.nxp.s32ds.ext.rcp.jface.DialogWidgetsUtil;
import com.nxp.s32ds.ext.rcp.jface.StringValidator;
import com.nxp.s32ds.ext.rcp.jface.internal.RcpJFaceActivator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StatusInputDialog
extends StatusDialog {
    private final String label;
    private final StringValidator validator;
    private final int textWidthHint;
    private String value;
    private Text textField;
    protected final ModifyListener listener = e -> {
        boolean bl = this.validate();
    };

    public StatusInputDialog(Shell parent, String title, String label, String initialValue, StringValidator validator, int textWidthHint) {
        super(parent);
        this.label = label;
        this.validator = validator;
        this.textWidthHint = textWidthHint;
        if (initialValue != null) {
            this.value = initialValue;
        }
        this.setTitle(title);
        this.setStatusLineAboveButtons(true);
    }

    public StatusInputDialog(Shell parent, String title, String label, String initialValue, StringValidator validator) {
        this(parent, title, label, initialValue, validator, 200);
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.textField.getText() : null;
        super.buttonPressed(buttonId);
    }

    public String getValue() {
        return this.value;
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        DialogWidgetsUtil.createLabel(composite, this.label, gridData);
        this.textField = new Text(composite, 2048);
        gridData = new GridData();
        gridData.widthHint = this.textWidthHint;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.textField.setLayoutData((Object)gridData);
        this.textField.addModifyListener(this.listener);
        if (this.value != null) {
            this.textField.setText(this.value);
        } else {
            this.updateStatus(RcpJFaceActivator.getInstance().createError(null));
        }
        return composite;
    }

    protected boolean validate() {
        IStatus status;
        if (this.validator != null && this.textField != null && !this.textField.isDisposed() && !(status = this.validator.validate(this.textField.getText())).isOK()) {
            this.updateStatus(status);
            return false;
        }
        this.updateStatus(RcpJFaceActivator.OK_STATUS_EMPTY_MSSAGE);
        return true;
    }
}

