/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controls;

import com.nxp.swtools.common.uct.controls.IBaseControl;
import com.nxp.swtools.common.uct.controls.IRefreshableBaseControl;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.BoolSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.ButtonSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.TreeStructSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controls.BoolSettingControl;
import com.nxp.swtools.gtm.controls.ButtonSettingControl;
import com.nxp.swtools.gtm.controls.EnumSettingControl;
import com.nxp.swtools.gtm.controls.IntegerSettingControl;
import com.nxp.swtools.gtm.controls.ListenerHandle;
import com.nxp.swtools.gtm.controls.StructSettingNode;
import com.nxp.swtools.gtm.controls.TextSettingControl;
import com.nxp.swtools.gtm.controls.TreeStructSettingNode;
import com.nxp.swtools.gtm.gui.GtmSceneCreator;
import com.nxp.swtools.gtm.model.xml.settings.GtmBoolSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmButtonSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmConstraintsTable;
import com.nxp.swtools.gtm.model.xml.settings.GtmEnumSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmIntegerSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmTextSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmTreeStructSetting;
import com.nxp.swtools.gtm.tasks.GtmRefreshTask;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import org.eclipse.ui.services.IDisposable;

public class GridPaneStructNode
extends GridPane
implements IRefreshableBaseControl,
IDisposable {
    private GtmStructSetting structSetting;
    private ListenerHandle<Boolean> disableStateHandle;

    public GridPaneStructNode(GtmStructSetting structSetting) {
        this.structSetting = structSetting;
        this.disableStateHandle = new ListenerHandle<Boolean>((ObservableValue<Boolean>)structSetting.getDisabledProperty(), this.createBoolRefreshListener());
        this.create();
    }

    public void create() {
        GtmConstraintsTable constraints = GtmController.getInstance().getGtmXmlConfig().getConstraints();
        this.structSetting.checkConstraints(GtmController.getInstance().getGtmMcu(), constraints);
        AnchorPane.setLeftAnchor((Node)this, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this, (Double)0.0);
        AnchorPane.setTopAnchor((Node)this, (Double)0.0);
        this.setHgap(20.0);
        this.setVgap(10.0);
        ColumnConstraints cc = new ColumnConstraints();
        cc.setHgrow(Priority.ALWAYS);
        this.getColumnConstraints().add((Object)cc);
        RowConstraints rc = new RowConstraints();
        rc.setVgrow(Priority.ALWAYS);
        this.getRowConstraints().add((Object)rc);
        this.setId(this.structSetting.getId());
        for (GtmStructSetting childStructSetting : this.structSetting.getStructSettings()) {
            if (!childStructSetting.getInitVisibleState()) continue;
            StructSettingNode childStructSettingNode = new StructSettingNode(childStructSetting);
            this.add((Node)childStructSettingNode.getRegion(), childStructSetting.getColumn(), childStructSetting.getRow(), childStructSetting.getColumnSpan(), childStructSetting.getRowSpan());
            GridPane.setFillWidth((Node)childStructSettingNode.getRegion(), (Boolean)Boolean.TRUE);
            GridPane.setFillHeight((Node)childStructSettingNode.getRegion(), (Boolean)Boolean.TRUE);
            GridPane.setValignment((Node)childStructSettingNode.getRegion(), (VPos)VPos.TOP);
        }
        for (GtmTextSetting textSetting : this.structSetting.getTextSettings()) {
            TextSettingControl textSettingControl = new TextSettingControl(textSetting, (Parent)this);
            this.add((Node)textSettingControl, textSetting.getColumn(), textSetting.getRow());
        }
        for (GtmBoolSetting boolSetting : this.structSetting.getBoolSettings()) {
            BoolSettingControl boolSettingControl = new BoolSettingControl((BoolSetting)boolSetting, (Parent)this);
            this.add((Node)boolSettingControl, boolSetting.getColumn(), boolSetting.getRow());
        }
        for (GtmEnumSetting enumSetting : this.structSetting.getEnumSettings()) {
            EnumSettingControl enumSettingControl = new EnumSettingControl(enumSetting, (Parent)this);
            this.add((Node)enumSettingControl, enumSetting.getColumn(), enumSetting.getRow());
        }
        for (GtmIntegerSetting integerSetting : this.structSetting.getIntegerSettings()) {
            IntegerSettingControl integerSettingControl = new IntegerSettingControl(integerSetting, (Parent)this);
            this.add((Node)integerSettingControl, integerSetting.getColumn(), integerSetting.getRow());
        }
        for (GtmButtonSetting buttonSetting : this.structSetting.getButtonSettings()) {
            ButtonSettingControl buttonSettingControl = new ButtonSettingControl((ButtonSetting)buttonSetting, (Parent)this);
            this.add((Node)buttonSettingControl, buttonSetting.getColumn(), buttonSetting.getRow());
        }
        for (GtmTreeStructSetting treeStructSetting : this.structSetting.getTreeStructSettings()) {
            TreeStructSettingNode treeStructSettingNode = new TreeStructSettingNode((TreeStructSetting)treeStructSetting);
            this.add((Node)treeStructSettingNode, treeStructSetting.getColumn(), treeStructSetting.getRow());
            GridPane.setFillWidth((Node)treeStructSettingNode, (Boolean)Boolean.TRUE);
            GridPane.setValignment((Node)treeStructSettingNode, (VPos)VPos.TOP);
            treeStructSettingNode.prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
            treeStructSettingNode.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        }
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.structSetting);
        GtmSceneCreator.getNodes().add((Node)this);
        this.addRefreshListeners();
    }

    public void refresh() {
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.structSetting);
        for (Node child : this.getChildren()) {
            if (!(child instanceof IBaseControl)) continue;
            ((IBaseControl)child).refresh();
        }
    }

    private ChangeListener<Boolean> createBoolRefreshListener() {
        return (obs, oldValue, newValue) -> Platform.runLater((Runnable)((Object)new GtmRefreshTask((IBaseControl)this)));
    }

    public void addRefreshListeners() {
        this.disableStateHandle.attach();
        for (Node childNode : this.getChildren()) {
            if (!(childNode instanceof IRefreshableBaseControl)) continue;
            ((IRefreshableBaseControl)childNode).addRefreshListeners();
        }
    }

    public void removeRefreshListeners() {
        this.disableStateHandle.detach();
        for (Node childNode : this.getChildren()) {
            if (!(childNode instanceof IRefreshableBaseControl)) continue;
            ((IRefreshableBaseControl)childNode).removeRefreshListeners();
        }
    }

    public void dispose() {
        this.removeRefreshListeners();
        for (Node child : this.getChildren()) {
            if (!(child instanceof IDisposable)) continue;
            ((IDisposable)child).dispose();
        }
        GtmSceneCreator.getNodes().remove((Object)this);
        this.getChildren().clear();
    }
}

