/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controls;

import com.nxp.swtools.common.uct.controller.AUctController;
import com.nxp.swtools.common.uct.controls.IBaseControl;
import com.nxp.swtools.common.uct.controls.IChildControl;
import com.nxp.swtools.common.uct.controls.IRefreshableBaseControl;
import com.nxp.swtools.common.uct.mcu.IMcu;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controls.ListenerHandle;
import com.nxp.swtools.gtm.gui.GtmSceneCreator;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.gtm.model.utils.GtmExpressions;
import com.nxp.swtools.gtm.model.xml.settings.GtmTextSetting;
import com.nxp.swtools.gtm.tasks.GtmRefreshTask;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import org.eclipse.ui.services.IDisposable;

public class TextSettingControl
extends HBox
implements IRefreshableBaseControl,
IChildControl,
IDisposable {
    private GtmTextSetting textSetting;
    protected Parent parent;
    private Label textSettingContent;
    private Label textSettingOutContent;
    private ListenerHandle<String> currentValueHandle;
    private ListenerHandle<String> currentValueOutHandle;
    private ListenerHandle<Boolean> visibleStateHandle;
    private ListenerHandle<Boolean> disableStateHandle;

    public TextSettingControl(GtmTextSetting textSetting, Parent parent) {
        this.textSetting = textSetting;
        this.parent = parent;
        this.textSettingContent = new Label();
        this.textSettingOutContent = new Label();
        this.currentValueHandle = new ListenerHandle<String>((ObservableValue<String>)textSetting.getCurrentValueProperty(), this.createStringRefreshListener());
        this.currentValueOutHandle = new ListenerHandle<String>((ObservableValue<String>)textSetting.getCurrentValueOutProperty(), this.createStringRefreshListener());
        this.visibleStateHandle = new ListenerHandle<Boolean>((ObservableValue<Boolean>)textSetting.getVisibleProperty(), this.createBoolRefreshListener());
        this.disableStateHandle = new ListenerHandle<Boolean>((ObservableValue<Boolean>)textSetting.getDisabledProperty(), this.createBoolRefreshListener());
        this.create();
    }

    public void create() {
        this.setId(this.textSetting.getId());
        Label textSettingLbl = new Label(this.textSetting.getLabel());
        textSettingLbl.setContentDisplay(ContentDisplay.RIGHT);
        textSettingLbl.getStyleClass().add((Object)"default-c-style");
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.textSetting);
        boolean visibleState = UctUtils.isComponentVisible((IMcu)GtmController.getInstance().getGtmMcu(), (ABaseUIComponentSetting)this.textSetting);
        this.setVisible(visibleState);
        this.textSettingContent = new Label();
        if (visibleState) {
            this.textSettingContent.setText(GtmExpressions.evaluateValueExpr((IGtmMcu)GtmController.getInstance().getGtmMcu(), (GtmTextSetting)this.textSetting));
        }
        textSettingLbl.setGraphic((Node)this.textSettingContent);
        textSettingLbl.setPadding(new Insets(20.0));
        this.getChildren().add((Object)textSettingLbl);
        this.getChildren().add((Object)this.textSettingContent);
        if (!this.textSetting.getLabelOut().isBlank()) {
            Label textSettingLblOut = new Label(this.textSetting.getLabelOut());
            textSettingLblOut.setContentDisplay(ContentDisplay.RIGHT);
            textSettingLblOut.getStyleClass().add((Object)"default-c-style");
            if (visibleState) {
                this.textSettingOutContent.setText(GtmExpressions.evaluateValueExprOut((IGtmMcu)GtmController.getInstance().getGtmMcu(), (GtmTextSetting)this.textSetting));
            }
            textSettingLblOut.setGraphic((Node)this.textSettingOutContent);
            textSettingLblOut.setPadding(new Insets(20.0));
            this.getChildren().add((Object)textSettingLblOut);
            this.getChildren().add((Object)this.textSettingOutContent);
        }
        GtmSceneCreator.getNodes().add((Node)this);
        GtmSceneCreator.getNodes().add((Node)textSettingLbl);
        GtmSceneCreator.getNodes().add((Node)this.textSettingContent);
        this.addRefreshListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        GtmTextSetting gtmTextSetting = this.textSetting;
        synchronized (gtmTextSetting) {
            UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.textSetting);
            boolean visibleState = UctUtils.isComponentVisible((IMcu)GtmController.getInstance().getGtmMcu(), (ABaseUIComponentSetting)this.textSetting);
            this.setVisible(visibleState);
            if (visibleState) {
                this.textSettingContent.setText(GtmExpressions.evaluateValueExpr((IGtmMcu)GtmController.getInstance().getGtmMcu(), (GtmTextSetting)this.textSetting));
                if (!this.textSetting.getLabelOut().isBlank()) {
                    this.textSettingOutContent.setText(GtmExpressions.evaluateValueExprOut((IGtmMcu)GtmController.getInstance().getGtmMcu(), (GtmTextSetting)this.textSetting));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefreshListeners() {
        GtmTextSetting gtmTextSetting = this.textSetting;
        synchronized (gtmTextSetting) {
            this.currentValueHandle.attach();
            this.currentValueOutHandle.attach();
            this.visibleStateHandle.attach();
            this.disableStateHandle.attach();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRefreshListeners() {
        GtmTextSetting gtmTextSetting = this.textSetting;
        synchronized (gtmTextSetting) {
            this.currentValueHandle.detach();
            this.currentValueOutHandle.detach();
            this.visibleStateHandle.detach();
            this.disableStateHandle.detach();
        }
    }

    public Parent getParentControl() {
        return this.parent;
    }

    public void setParentControl(Parent parent) {
        this.parent = parent;
    }

    private ChangeListener<String> createStringRefreshListener() {
        return (obs, oldValue, newValue) -> Platform.runLater((Runnable)((Object)new GtmRefreshTask((IBaseControl)this)));
    }

    private ChangeListener<Boolean> createBoolRefreshListener() {
        return (obs, oldValue, newValue) -> Platform.runLater((Runnable)((Object)new GtmRefreshTask((IBaseControl)this)));
    }

    public void dispose() {
        this.removeRefreshListeners();
        UctLayoutUtils.removeListenerForControl((AUctController)GtmController.getInstance(), (IChildControl)this);
        GtmSceneCreator.getNodes().remove((Object)this);
        this.getChildren().clear();
    }

    public Label getTextSettingContent() {
        return this.textSettingContent;
    }

    public Label getTextSettingOutContent() {
        return this.textSettingOutContent;
    }
}

