/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.group.launch;

import com.nxp.s32ds.debug.ide.core.DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.group.internal.launch.S32DebuggerGroupLaunchMessages;
import com.nxp.s32ds.debug.ide.s32debugger.group.launch.S32DebuggerGroupLaunch;
import com.nxp.s32ds.debug.ide.s32debugger.group.launch.S32DebuggerSingleLaunchElement;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandler;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class S32DebuggerGroupLaunchConfigurationDelegate
extends LaunchConfigurationDelegate
implements RcpStatusHandler {
    public static final String DEFAULT_MODE = "default";
    public static final String ATTR_MODE = "mode";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_ENABLED = "enabled";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_ACTION_PARAM = "actionParam";
    public static final String MULTI_LAUNCH_CONSTANTS_PREFIX = "com.nxp.s32ds.debug.ide.s32debugger.groupLaunch";
    public static final String PLUGIN_ID = "com.nxp.s32ds.debug.ide.s32debugger.group.launch";
    private static final String DEBUG_SESSION_STATUS_HANDLER_ID = "com.freescale.s32ds.cdt.debug.debugSessionStatusHandler";
    private static final String DUMMY_VALUE_STATUS = "dummy value";
    private static final int USE_NEW_SESSION = 0;
    private static final Object GROUP_CHANGING_SYNCHRONIZER = new Object();
    private static final Object GROUP_WAITING_SYNCHRONIZER = new Object();
    private static final Object TERMINATION_SYNCHRONIZER = new Object();
    private static final Object RUN_SYNCHRONIZER = new Object();
    private static volatile S32DebuggerGroupLaunch groupLaunch;
    private static Thread groupThread;
    private static boolean preLaunchCheckPassed;
    private static boolean canBeInterrupted;
    private static String configurationNameToReachBP;
    private static final int SUBMONITOR_WORK = 100;
    private static String TEMP_BREAKPOINTS;

    static {
        TEMP_BREAKPOINTS = "org.eclipse.cdt.debug.core.cFunctionBreakpointMarker";
    }

    protected void buildProjects(IProject[] projects, IProgressMonitor monitor) throws CoreException {
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    public static boolean hasLaunchRunning() {
        return groupLaunch != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Object object = RUN_SYNCHRONIZER;
        synchronized (object) {
            block31: {
                SubMonitor subMonitor;
                block32: {
                    subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    try {
                        IBreakpoint[] breakpoints;
                        List<S32DebuggerSingleLaunchElement> launches = this.createLaunchElements(configuration, new ArrayList<S32DebuggerSingleLaunchElement>());
                        groupLaunch.setSingleLaunchesQuantity(launches.size());
                        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
                        int n = breakpoints.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IBreakpoint breakpoint = iBreakpointArray[n2];
                            if (breakpoint.getMarker().getType().toString().equals(TEMP_BREAKPOINTS)) {
                                breakpoint.delete();
                            }
                            ++n2;
                        }
                        groupThread = Thread.currentThread();
                        for (S32DebuggerSingleLaunchElement sLaunch : launches) {
                            ILaunch subLaunch;
                            ILaunchConfiguration conf = this.findLaunch(sLaunch.launchName);
                            if (conf == null) {
                                groupLaunch.skipSingleLaunch();
                                continue;
                            }
                            String localMode = sLaunch.launchMode != null && !DEFAULT_MODE.equals(sLaunch.launchMode) ? sLaunch.launchMode : mode;
                            if (!conf.supportsMode(localMode)) {
                                throw new CoreException((IStatus)new Status(4, PLUGIN_ID, NLS.bind((String)S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_wrong_launch_started, (Object)conf.getName())));
                            }
                            if (configuration.getName().equals(conf.getName())) {
                                throw new CoreException((IStatus)new Status(4, PLUGIN_ID, S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_wrong_launch_started));
                            }
                            Object object2 = GROUP_CHANGING_SYNCHRONIZER;
                            synchronized (object2) {
                                if (groupLaunch == null || groupLaunch.isTerminated()) {
                                    break;
                                }
                                groupLaunch.addLaunch(conf.getName());
                                configurationNameToReachBP = S32DebuggerSingleLaunchElement.ActionAfterLaunch.ACTION_WAIT_FOR_STOP_ON_BP.equals((Object)sLaunch.actionAfterLaunch) ? conf.getName() : null;
                                subLaunch = conf.launch(localMode, (IProgressMonitor)new NullProgressMonitor());
                                if (groupLaunch != null) {
                                    if (!S32DebuggerSingleLaunchElement.ActionAfterLaunch.ACTION_WAIT_FOR_TERMINATION.equals((Object)sLaunch.actionAfterLaunch) && subLaunch.isTerminated()) {
                                        groupLaunch.terminateIndirectly();
                                        groupLaunch = null;
                                        break;
                                    }
                                    groupLaunch.addRunningLaunch(subLaunch);
                                    groupLaunch.launchChanged(subLaunch);
                                }
                                DebugUIPlugin.getDefault().getLaunchConfigurationManager().setRecentLaunch(launch);
                            }
                            object2 = GROUP_WAITING_SYNCHRONIZER;
                            synchronized (object2) {
                                if (groupLaunch == null || groupLaunch.isTerminated()) {
                                    break;
                                }
                                canBeInterrupted = true;
                                this.postLaunchAction(subLaunch, sLaunch.actionAfterLaunch, sLaunch.launchActionData, (IProgressMonitor)subMonitor);
                                canBeInterrupted = false;
                            }
                        }
                        groupThread = null;
                    }
                    catch (DebugException ex) {
                        DebugUIPlugin.getStandardDisplay().asyncExec(() -> {
                            int n = ErrorDialog.openError((Shell)DebugUIPlugin.getShell(), (String)S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_error_title, null, (IStatus)ex.getStatus());
                        });
                        if (groupThread != null) {
                            groupThread = null;
                            if (groupLaunch != null) {
                                groupLaunch.terminateIndirectly();
                            }
                            groupLaunch = null;
                        }
                        subMonitor.worked(100);
                        subMonitor.done();
                        break block31;
                    }
                    catch (Exception ex) {
                        try {
                            DebugUIPlugin.getStandardDisplay().asyncExec(() -> {
                                int n = ErrorDialog.openError((Shell)DebugUIPlugin.getShell(), (String)S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_error_title, (String)S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_debugger_error, (IStatus)new Status(4, PLUGIN_ID, ex.getMessage()));
                            });
                            break block31;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (groupThread != null) {
                                groupThread = null;
                                if (groupLaunch != null) {
                                    groupLaunch.terminateIndirectly();
                                }
                                groupLaunch = null;
                            }
                            subMonitor.worked(100);
                            subMonitor.done();
                        }
                    }
                    if (groupThread == null) break block32;
                    groupThread = null;
                    if (groupLaunch != null) {
                        groupLaunch.terminateIndirectly();
                    }
                    groupLaunch = null;
                }
                subMonitor.worked(100);
                subMonitor.done();
            }
        }
    }

    private List<S32DebuggerSingleLaunchElement> createLaunchElements(ILaunchConfiguration configuration, List<S32DebuggerSingleLaunchElement> launchesList) {
        try {
            Map attrs = configuration.getAttributes();
            for (String attr : attrs.keySet()) {
                try {
                    S32DebuggerSingleLaunchElement.ActionAfterLaunch action;
                    if (!attr.startsWith(MULTI_LAUNCH_CONSTANTS_PREFIX)) continue;
                    String launchAttribute = attr.substring(MULTI_LAUNCH_CONSTANTS_PREFIX.length() + 1);
                    int dotPos = launchAttribute.indexOf(46);
                    String launchNum = launchAttribute.substring(0, dotPos);
                    int index = Integer.parseInt(launchNum);
                    String attrVal = launchAttribute.substring(dotPos + 1);
                    if (!ATTR_NAME.equals(attrVal)) continue;
                    S32DebuggerSingleLaunchElement sLaunch = new S32DebuggerSingleLaunchElement();
                    sLaunch.launchName = (String)attrs.get(attr);
                    Integer actionData = null;
                    String actionStr = (String)attrs.get(this.getClassifier(index, ATTR_ACTION));
                    try {
                        action = S32DebuggerSingleLaunchElement.ActionAfterLaunch.valueOf(actionStr);
                    }
                    catch (Exception exception) {
                        action = S32DebuggerSingleLaunchElement.ActionAfterLaunch.ACTION_NONE;
                    }
                    if (action == S32DebuggerSingleLaunchElement.ActionAfterLaunch.ACTION_DELAY) {
                        try {
                            actionData = Integer.parseInt((String)attrs.get(this.getClassifier(index, ATTR_ACTION_PARAM)));
                        }
                        catch (NumberFormatException ex) {
                            DebuggerCoreActivator.getInstance().logError(ex.getMessage());
                        }
                    }
                    sLaunch.actionAfterLaunch = action;
                    sLaunch.launchActionData = actionData;
                    sLaunch.launchMode = (String)attrs.get(this.getClassifier(index, ATTR_MODE));
                    sLaunch.launchEnabled = Boolean.parseBoolean((String)attrs.get(this.getClassifier(index, ATTR_ENABLED)));
                    sLaunch.lcData = configuration;
                    while (index >= launchesList.size()) {
                        launchesList.add(null);
                    }
                    launchesList.set(index, sLaunch);
                }
                catch (Exception ex) {
                    DebuggerCoreActivator.getInstance().logError(ex.getMessage());
                }
            }
        }
        catch (CoreException ex) {
            DebuggerCoreActivator.getInstance().logError(ex.getMessage());
        }
        int i = launchesList.size() - 1;
        while (i >= 0) {
            if (!launchesList.get((int)i).launchEnabled) {
                launchesList.remove(i);
            }
            --i;
        }
        return launchesList;
    }

    private String getClassifier(int index, String string) {
        return "com.nxp.s32ds.debug.ide.s32debugger.groupLaunch." + index + "." + string;
    }

    private ILaunchConfiguration findLaunch(String name) throws CoreException {
        ILaunchConfiguration[] launchConfigurations;
        ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
        int n = launchConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration lConf = iLaunchConfigurationArray[n2];
            if (lConf.getName().equals(name)) {
                return lConf;
            }
            ++n2;
        }
        return null;
    }

    private void postLaunchAction(ILaunch subLaunch, S32DebuggerSingleLaunchElement.ActionAfterLaunch action, Object actionParam, IProgressMonitor monitor) throws DebugException {
        boolean interrupted = false;
        switch (action) {
            case ACTION_NONE: {
                break;
            }
            case ACTION_WAIT_FOR_STOP_ON_BP: {
                monitor.subTask(S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_progress_action_waiting_for_stop_on_bp);
                while (!groupThread.isInterrupted() && configurationNameToReachBP != null) {
                    interrupted = false;
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                    }
                    if (interrupted) continue;
                    monitor.subTask("");
                    throw new DebugException((IStatus)new Status(4, PLUGIN_ID, S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_error_no_stop_bp));
                }
                monitor.subTask("");
                break;
            }
            case ACTION_WAIT_FOR_TERMINATION: {
                monitor.subTask(String.valueOf(S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_progress_action_waiting_for_termination) + " " + subLaunch.getLaunchConfiguration().getName());
                while (!(subLaunch.isTerminated() || interrupted || groupThread.isInterrupted())) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                    }
                }
                monitor.subTask("");
                break;
            }
            case ACTION_DELAY: {
                Integer waitSecs = (Integer)actionParam;
                if (waitSecs == null) break;
                monitor.subTask(NLS.bind((String)S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_progress_action_delaying, (Object)waitSecs.toString()));
                try {
                    Thread.sleep(waitSecs * 1000);
                }
                catch (InterruptedException interruptedException) {}
                monitor.subTask("");
                break;
            }
            default: {
                assert (false) : S32DebuggerGroupLaunchMessages.S32DebuggerGroupLaunch_action_wrong_type;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        if (groupLaunch != null) {
            boolean newSession;
            Status status = new Status(0, DUMMY_VALUE_STATUS, "");
            int userChoice = (Integer)RcpStatusHandlers.handleStatus((String)DEBUG_SESSION_STATUS_HANDLER_ID, (IStatus)status, (Object)configuration);
            boolean bl = newSession = userChoice == 0;
            if (newSession) {
                Object object = TERMINATION_SYNCHRONIZER;
                synchronized (object) {
                    if (groupLaunch != null) {
                        this.terminateGroup(groupLaunch);
                    }
                }
            } else {
                preLaunchCheckPassed = false;
                return null;
            }
        }
        Object object = RUN_SYNCHRONIZER;
        synchronized (object) {
            groupLaunch = new S32DebuggerGroupLaunch(configuration, mode);
            preLaunchCheckPassed = true;
        }
        return groupLaunch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        ILaunch launch = (ILaunch)source;
        switch (status.getSeverity()) {
            case 4: {
                Object object = TERMINATION_SYNCHRONIZER;
                synchronized (object) {
                    if (groupLaunch != null && groupLaunch.hasLaunch(launch)) {
                        this.terminateGroup(groupLaunch);
                        return Boolean.TRUE;
                    }
                    break;
                }
            }
            case 1: {
                if (configurationNameToReachBP == null) break;
                Object object = GROUP_CHANGING_SYNCHRONIZER;
                synchronized (object) {
                    if (configurationNameToReachBP.equals(launch.getLaunchConfiguration().getName())) {
                        new Thread(() -> {
                            configurationNameToReachBP = null;
                            if (groupThread != null && canBeInterrupted) {
                                groupThread.interrupt();
                            }
                        }).start();
                    }
                    break;
                }
            }
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setTerminated() {
        Object object = TERMINATION_SYNCHRONIZER;
        synchronized (object) {
            if (groupLaunch != null) {
                groupLaunch = null;
                new Thread(() -> {
                    if (groupThread != null && canBeInterrupted) {
                        groupThread.interrupt();
                    }
                }).start();
            }
        }
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (!preLaunchCheckPassed) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.worked(100);
            subMonitor.done();
            return false;
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateGroup(S32DebuggerGroupLaunch launchToTerminate) {
        Object object = GROUP_CHANGING_SYNCHRONIZER;
        synchronized (object) {
            if (groupThread != null && canBeInterrupted) {
                groupThread.interrupt();
            }
            Object object2 = GROUP_WAITING_SYNCHRONIZER;
            synchronized (object2) {
                if (!launchToTerminate.isTerminated()) {
                    groupLaunch = null;
                    launchToTerminate.terminateIndirectly();
                }
            }
        }
    }

    public static boolean isConfigurationTypeIsSuitableForGroup(String configId) {
        return "com.nxp.s32ds.debug.ide.s32debugger.core.s32DebuggerLaunchConfigurationType".equals(configId) || "com.nxp.s32ds.debug.ide.s32debugger.flash.core.s32DebuggerFlashProgrammerLaunchConfigurationType".equals(configId);
    }
}

