/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.registry.ui.tree;

import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.ui.tree.HardwareContentProvider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class HardwareDeviceContentProvider
extends HardwareContentProvider {
    private final Map<FamilyDescriptor, List<DeviceDescriptor>> families;

    public HardwareDeviceContentProvider() {
        this("");
    }

    public HardwareDeviceContentProvider(String debuggerId) {
        this.families = HardwareDeviceContentProvider.getFamilyToDeviceMap(debuggerId).entrySet().stream().collect(Collectors.toMap(entry -> (FamilyDescriptor)entry.getKey(), entry -> ((Map)entry.getValue()).keySet().stream().collect(Collectors.toList())));
    }

    private Set<DeviceDescriptor> getDevices() {
        return this.families.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toSet());
    }

    public Object[] getChildren(Object arg) {
        if (arg instanceof List) {
            List lstObjects = (List)arg;
            return lstObjects.toArray(new Object[0]);
        }
        if (arg instanceof FamilyDescriptor) {
            FamilyDescriptor family = (FamilyDescriptor)arg;
            List<DeviceDescriptor> devices = this.families.get(family);
            return devices.toArray(new DeviceDescriptor[0]);
        }
        return new Object[0];
    }

    public boolean hasChildren(Object element) {
        if (element instanceof FamilyDescriptor) {
            FamilyDescriptor fmlDescriptor = (FamilyDescriptor)element;
            return !this.families.get(fmlDescriptor).isEmpty();
        }
        return false;
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        return null;
    }

    @Override
    public Class<?> getSelectionType() {
        return DeviceDescriptor.class;
    }

    @Override
    public List<String> getFamilyIds() {
        return this.families.keySet().stream().map(familyDesc -> familyDesc.getId()).collect(Collectors.toList());
    }

    @Override
    public List<String> getDeviceIds() {
        return this.getDevices().stream().map(deviceDesc -> deviceDesc.getId()).collect(Collectors.toList());
    }

    @Override
    public List<String> getDeviceCoreIds() {
        return Collections.emptyList();
    }

    @Override
    public List<FamilyDescriptor> getFamilyDescriptors() {
        return this.families.keySet().stream().collect(Collectors.toList());
    }
}

