/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui;

import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.MemorySpacesDialog;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.MemorySpacesUIActivator;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.MemorySpacesViewer;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.data.MemoryBase;
import com.nxp.s32ds.cle.runtime.memory.spaces.core.DeviceCoreMemorySpaceDescriptor;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.actions.DsfViewMemoryHandler;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.VariableVMNode;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ViewInMemorySpace
extends DsfViewMemoryHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        VariableVMNode.VariableExpressionVMC[] contexts = this.getMemoryViewables();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart memoryView = null;
        try {
            memoryView = page.showView("com.nxp.s32ds.cle.cdt.memory.spaces.ui.viewer", null, 1);
        }
        catch (PartInitException e) {
            MemorySpacesUIActivator.getInstance().logError(e.getLocalizedMessage(), e);
            return null;
        }
        MemorySpacesViewer memorySpacesViewer = (MemorySpacesViewer)memoryView;
        List<DeviceCoreMemorySpaceDescriptor> deviceCoreMemorySpaceslist = MemoryBase.getInstance().getMemorySpacesByContext();
        this.addVariablesInMemorySpaces(contexts, memorySpacesViewer, deviceCoreMemorySpaceslist);
        return null;
    }

    private void addVariablesInMemorySpaces(VariableVMNode.VariableExpressionVMC[] contexts, MemorySpacesViewer memorySpacesViewer, List<DeviceCoreMemorySpaceDescriptor> list) {
        VariableVMNode.VariableExpressionVMC[] variableExpressionVMCArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IExpressions.IExpressionDMData expressionDMData;
            DsfExecutor executor;
            DsfSession session;
            VariableVMNode.VariableExpressionVMC context = variableExpressionVMCArray[n2];
            IExpressions.IExpressionDMContext dmc = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)context.getDMContext(), IExpressions.IExpressionDMContext.class);
            if (dmc != null && (session = DsfSession.getSession((String)context.getDMContext().getSessionId())) != null && (executor = session.getExecutor()) != null && (expressionDMData = this.getVariableExpressionDMData(executor, session, dmc)) != null) {
                String exprString = "";
                exprString = expressionDMData.getBasicType() == IExpressions.IExpressionDMData.BasicType.array || expressionDMData.getBasicType() == IExpressions.IExpressionDMData.BasicType.pointer ? context.getExpression() : "&(" + context.getExpression() + ")";
                this.addVariableInMemorySpaces(memorySpacesViewer, list, exprString);
            }
            ++n2;
        }
    }

    private void addVariableInMemorySpaces(MemorySpacesViewer memorySpacesViewer, List<DeviceCoreMemorySpaceDescriptor> list, String exprString) {
        MemorySpacesDialog dialog = new MemorySpacesDialog(Display.getCurrent().getActiveShell(), Messages.MemorySpaceDelegate_selection_dialog_title, list, exprString);
        if (dialog.open() != 0) {
            return;
        }
        try {
            memorySpacesViewer.addTabForMemorySpace(dialog.getMemorySpace(), null);
            memorySpacesViewer.updateView();
        }
        catch (CoreException e) {
            MemorySpacesUIActivator.getInstance().log(e.getStatus());
        }
    }

    private IExpressions.IExpressionDMData getVariableExpressionDMData(DsfExecutor executor, DsfSession session, IExpressions.IExpressionDMContext dmc) {
        Query<IExpressions.IExpressionDMData> query = this.getExpressionDMDataQuery(executor, session, dmc);
        executor.execute(query);
        IExpressions.IExpressionDMData expressionDMData = null;
        try {
            expressionDMData = (IExpressions.IExpressionDMData)query.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | java.util.concurrent.ExecutionException | TimeoutException e) {
            MemorySpacesUIActivator.getInstance().logError(e.getLocalizedMessage(), e);
            return null;
        }
        return expressionDMData;
    }

    private Query<IExpressions.IExpressionDMData> getExpressionDMDataQuery(final DsfExecutor executor, final DsfSession session, final IExpressions.IExpressionDMContext dmc) {
        return new Query<IExpressions.IExpressionDMData>(){

            protected void execute(final DataRequestMonitor<IExpressions.IExpressionDMData> rm) {
                DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), session.getId());
                IExpressions service = (IExpressions)tracker.getService(IExpressions.class);
                tracker.dispose();
                if (service != null) {
                    service.getExpressionData(dmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMData>((Executor)executor, null){

                        protected void handleSuccess() {
                            rm.done((Object)((IExpressions.IExpressionDMData)this.getData()));
                        }

                        protected void handleErrorOrWarning() {
                            rm.done(this.getStatus());
                        }
                    });
                }
            }
        };
    }

    public void setEnabled(Object evaluationContext) {
        if (MemoryBase.getInstance().getMemorySpacesByContext().isEmpty()) {
            this.setBaseEnabled(false);
            return;
        }
        super.setEnabled(evaluationContext);
    }
}

