/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.data;

import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.MemorySpacesViewer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingSynchronizationService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.ui.IWorkbenchPartSite;

public class MemorySpaceRenderingContainer
implements IMemoryRenderingContainer,
IMemoryRenderingSite {
    private static final String COTAINER_ID = "com.nxp.s32ds.cle.cdt.memory.spaces.container";
    private static final String MEMORY_SPACE_RENDERING_TAB_ID = "memory.space.rendering.data";
    private final List<IMemoryRendering> renderings;
    private final MemorySpacesViewer viewer;
    private final ISelectionProvider provider;

    public MemorySpaceRenderingContainer(MemorySpacesViewer viewer) {
        this.viewer = viewer;
        this.renderings = new ArrayList<IMemoryRendering>();
        this.provider = new RenderingSelectionProvider();
    }

    public void addMemoryRendering(IMemoryRendering rendering) {
        if (!this.renderings.contains(rendering)) {
            this.renderings.add(rendering);
        }
    }

    public IMemoryRendering getActiveRendering() {
        Object rendering;
        CTabItem selection = this.viewer.getActiveCTab();
        if (selection != null && (rendering = selection.getData(MEMORY_SPACE_RENDERING_TAB_ID)) instanceof IMemoryRendering) {
            return (IMemoryRendering)rendering;
        }
        return null;
    }

    public String getId() {
        return COTAINER_ID;
    }

    public String getLabel() {
        IMemoryRendering rendering = this.getActiveRendering();
        return rendering != null ? rendering.getLabel() : null;
    }

    public IMemoryRenderingSite getMemoryRenderingSite() {
        return this;
    }

    public IMemoryRendering[] getRenderings() {
        return this.renderings.toArray(new IMemoryRendering[0]);
    }

    public void removeMemoryRendering(IMemoryRendering rendering) {
        this.renderings.remove(rendering);
    }

    public IWorkbenchPartSite getSite() {
        return this.viewer.getSite();
    }

    public IMemoryRenderingSynchronizationService getSynchronizationService() {
        return null;
    }

    public IMemoryRenderingContainer[] getMemoryRenderingContainers() {
        return new IMemoryRenderingContainer[]{this};
    }

    public IMemoryRenderingContainer getContainer(String id) {
        return this.getId().equals(id) ? this : null;
    }

    public ISelectionProvider getRenderingSelectionProvider() {
        return this.provider;
    }

    public String getRenderingTabDataId() {
        return MEMORY_SPACE_RENDERING_TAB_ID;
    }

    private final class RenderingSelectionProvider
    implements ISelectionProvider {
        private RenderingSelectionProvider() {
        }

        public void setSelection(ISelection selection) {
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            IMemoryRendering rendering = MemorySpaceRenderingContainer.this.getActiveRendering();
            return rendering != null ? new StructuredSelection((Object)rendering) : null;
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }
    }
}

