/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.provider;

import com.nxp.s32ds.cle.runtime.migration.internal.entity.Messages;
import com.nxp.s32ds.cle.runtime.migration.internal.provider.MigrationProviderActivator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;

public interface MigrationProvider {
    default public boolean isApplicable(String sourceId, String targetId, Map<String, Object> attributes) {
        IProject project = (IProject)attributes.get("s32ds.migration.payload.attributes.project");
        if (project == null) {
            throw new IllegalStateException(Messages.MigrationEntity_project_is_null);
        }
        IStatus status = this.checkMigrationConditions(sourceId, targetId, attributes);
        if (!status.isOK()) {
            MigrationProviderActivator.getInstance().log(status);
        }
        return status.isOK();
    }

    default public void assertSourceId(String sourceId) {
        if (sourceId == null) {
            throw new IllegalStateException(Messages.MigrationEntity_source_is_null);
        }
        if (sourceId.isEmpty()) {
            throw new IllegalStateException(Messages.MigrationEntity_source_is_empty);
        }
    }

    default public void assertTargetId(String targetId) {
        if (targetId == null) {
            throw new IllegalStateException(Messages.MigrationEntity_target_is_null);
        }
        if (targetId.isEmpty()) {
            throw new IllegalStateException(Messages.MigrationEntity_target_is_empty);
        }
    }

    public IStatus checkMigrationConditions(String var1, String var2, Map<String, Object> var3);
}

