/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.figures;

import org.eclipse.nebula.visualization.widgets.figureparts.RoundScale;
import org.eclipse.nebula.visualization.widgets.figureparts.RoundScaledRamp;
import org.eclipse.nebula.visualization.widgets.figures.AbstractMarkedWidgetFigure;
import org.eclipse.swt.graphics.Color;

public class AbstractRoundRampedFigure
extends AbstractMarkedWidgetFigure {
    protected boolean gradient = true;
    protected RoundScaledRamp ramp;

    public AbstractRoundRampedFigure() {
        this.scale = new RoundScale();
        this.ramp = new RoundScaledRamp((RoundScale)this.scale);
    }

    @Override
    public void setShowMarkers(boolean showMarkers) {
        super.setShowMarkers(showMarkers);
        this.ramp.setVisible(showMarkers);
    }

    @Override
    public void setLoloLevel(double loloLevel) {
        super.setLoloLevel(loloLevel);
        this.ramp.setThresholdValue(RoundScaledRamp.Threshold.LOLO, loloLevel);
    }

    @Override
    public void setLoLevel(double loLevel) {
        super.setLoLevel(loLevel);
        this.ramp.setThresholdValue(RoundScaledRamp.Threshold.LO, loLevel);
    }

    @Override
    public void setHiLevel(double hiLevel) {
        super.setHiLevel(hiLevel);
        this.ramp.setThresholdValue(RoundScaledRamp.Threshold.HI, hiLevel);
    }

    @Override
    public void setHihiLevel(double hihiLevel) {
        super.setHihiLevel(hihiLevel);
        this.ramp.setThresholdValue(RoundScaledRamp.Threshold.HIHI, hihiLevel);
    }

    @Override
    public void setShowLolo(boolean showLolo) {
        super.setShowLolo(showLolo);
        this.ramp.setThresholdVisibility(RoundScaledRamp.Threshold.LOLO, showLolo);
    }

    @Override
    public void setShowLo(boolean showLo) {
        super.setShowLo(showLo);
        this.ramp.setThresholdVisibility(RoundScaledRamp.Threshold.LO, showLo);
    }

    @Override
    public void setShowHi(boolean showHi) {
        super.setShowHi(showHi);
        this.ramp.setThresholdVisibility(RoundScaledRamp.Threshold.HI, showHi);
    }

    @Override
    public void setShowHihi(boolean showHihi) {
        super.setShowHihi(showHihi);
        this.ramp.setThresholdVisibility(RoundScaledRamp.Threshold.HIHI, showHihi);
    }

    @Override
    public void setLoloColor(Color color) {
        super.setLoloColor(color);
        this.ramp.setThresholdColor(RoundScaledRamp.Threshold.LOLO, color.getRGB());
        this.repaint();
    }

    @Override
    public void setLoColor(Color color) {
        super.setLoColor(color);
        this.ramp.setThresholdColor(RoundScaledRamp.Threshold.LO, color.getRGB());
        this.repaint();
    }

    @Override
    public void setHiColor(Color color) {
        super.setHiColor(color);
        this.ramp.setThresholdColor(RoundScaledRamp.Threshold.HI, color.getRGB());
        this.repaint();
    }

    @Override
    public void setHihiColor(Color color) {
        super.setHihiColor(color);
        this.ramp.setThresholdColor(RoundScaledRamp.Threshold.HIHI, color.getRGB());
        this.repaint();
    }

    public void setGradient(boolean gradient) {
        if (this.gradient == gradient) {
            return;
        }
        this.gradient = gradient;
        this.ramp.setGradient(gradient);
        this.repaint();
    }

    @Override
    public void setRange(double min, double max) {
        super.setRange(min, max);
        this.ramp.setDirty(true);
    }

    @Override
    public void setLogScale(boolean logScale) {
        super.setLogScale(logScale);
        this.ramp.setDirty(true);
    }

    public boolean isGradient() {
        return this.gradient;
    }
}

