/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.backend;

import com.freescale.s32ds.cross.core.model.context.GeneralContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import java.io.File;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class ProjectGenerationContext {
    private IProject project;
    private final ProjectContext projectContext;
    private final GeneralContext generalContext;

    ProjectGenerationContext(GeneralContext generalContext, ProjectContext projectContext) {
        this.projectContext = projectContext;
        this.generalContext = generalContext;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        if (this.project != null) {
            throw new IllegalStateException("project is already set");
        }
        this.project = project;
    }

    public String getProjectName() {
        return this.projectContext.getProjectName();
    }

    public ProjectContext getProjectContext() {
        return this.projectContext;
    }

    public GeneralContext getGeneralContext() {
        return this.generalContext;
    }

    public boolean isLastProjectLocationExists() {
        return this.getLocation() != null && new File(this.getLocation()).exists();
    }

    public static ProjectGenerationContext start(GeneralContext generalContext, ProjectContext projectContext) {
        return new ProjectGenerationContext(generalContext, projectContext);
    }

    public String getLocation() {
        return ProjectGenerationContext.getLocation(this.generalContext, this.projectContext);
    }

    public static String getLocation(GeneralContext generalContext, ProjectContext projectContext) {
        String projectBaseName = projectContext.getProjectBaseName();
        String path = String.valueOf(Optional.ofNullable(generalContext.getBaseProjectPath()).orElse(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString())) + File.separator + projectBaseName;
        ProcessorData currentProcessor = generalContext.getCurrentProcessor();
        if (currentProcessor != null) {
            int cores;
            int n = cores = generalContext.isExecutable() ? currentProcessor.getCores().size() : currentProcessor.getCoreTypes().size();
            if (cores > 1) {
                path = String.valueOf(path) + File.separator + projectBaseName + "_" + projectContext.getSuffix();
            }
        }
        return path;
    }
}

