/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data;

import com.nxp.swtools.clocks.data.ErrorHelper;
import com.nxp.swtools.clocks.data.IConstraint;
import com.nxp.swtools.clocks.data.PowerModeContext;
import com.nxp.swtools.clocks.data.elements.PowerMode;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.expression.ConfigContext;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.model.FrequencyRange;
import com.nxp.swtools.clocks.utils.Converter;
import com.nxp.swtools.clocks.utils.Text;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.frequency.FrequencyCalculator;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Constraint
implements IConstraint {
    @NonNull
    private @NonNull Map<@NonNull String, String> constraints = new HashMap<String, String>();
    @NonNull
    private static final String MIN_FREQ = "min_freq";
    @NonNull
    private static final String MAX_FREQ = "max_freq";
    @NonNull
    private static final String DEFAULT_FREQ = "default_freq";
    @NonNull
    private static final String NOT_RESOLVABLE_EX = "Not resolvable expression: ";
    @Nullable
    private Expression restriction;
    @Nullable
    private Expression condition;
    @NonNull
    private String elementID;
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(Constraint.class);
    boolean isOnInput = false;
    @NonNull
    private Level level;
    @Nullable
    private BigRational accuracy;
    @Nullable
    private Collection<@NonNull PowerMode> influencedPowerModes;

    public Constraint(@NonNull String elementID, boolean isOnInput, @NonNull Level level) {
        this.elementID = elementID;
        this.isOnInput = isOnInput;
        this.level = level;
    }

    public Constraint(@NonNull String elementID, boolean isOnInput, @NonNull String levelName) {
        this(elementID, isOnInput, Level.getLevel(levelName));
    }

    public Constraint(@NonNull String elementID) {
        this(elementID, false, Level.ERROR);
    }

    public void add(@NonNull String name, @Nullable String value) {
        if (value != null && !"".equals(value)) {
            this.constraints.put(name, value);
        }
    }

    public boolean isApplicable(@NonNull IClocksConfig config) {
        boolean applicable = true;
        Expression restrictionLoc = this.restriction;
        if (restrictionLoc != null) {
            try {
                IContext parentContext = restrictionLoc.getContext();
                ConfigContext context = new ConfigContext(parentContext, config);
                applicable = restrictionLoc.resolve(context).getBoolean();
            }
            catch (RuntimeException e) {
                LOGGER.log(java.util.logging.Level.WARNING, NOT_RESOLVABLE_EX + restrictionLoc.toString(), e);
                applicable = true;
            }
        }
        return applicable;
    }

    public boolean isApplicable(@NonNull IClocksConfig config, @NonNull BigRational value) {
        boolean applicable = true;
        Expression restrictionLoc = this.restriction;
        if (restrictionLoc != null) {
            IContext parentContext = restrictionLoc.getContext();
            ConfigContext context = new ConfigContext(parentContext, config);
            IValue resolvedRestriction = restrictionLoc.resolve(context);
            switch (resolvedRestriction.getType()) {
                case BIG_RATIONAL: 
                case LONG: {
                    BigRational rational = resolvedRestriction.getRational();
                    applicable = rational.compareTo(value) == 0;
                    break;
                }
                case BOOLEAN: {
                    applicable = this.isApplicable(config);
                    break;
                }
                default: {
                    LOGGER.warning(NOT_RESOLVABLE_EX + restrictionLoc.toString() + "for value: " + value);
                }
            }
        }
        return applicable;
    }

    public boolean isValid(@NonNull IClocksConfig config) {
        return this.isValid(config, null);
    }

    public boolean isValid(@NonNull IClocksConfig config, @Nullable BigRational value) {
        boolean valid = true;
        if (value != null ? !this.isApplicable(config, value) : !this.isApplicable(config)) {
            return valid;
        }
        Expression conditionLoc = this.condition;
        if (conditionLoc != null) {
            try {
                IContext parentContext = conditionLoc.getContext();
                ConfigContext context = new ConfigContext(parentContext, config);
                valid = conditionLoc.resolve(context).getBoolean();
            }
            catch (RuntimeException e) {
                LOGGER.log(java.util.logging.Level.WARNING, NOT_RESOLVABLE_EX + conditionLoc.toString(), e);
                valid = false;
            }
        }
        return valid;
    }

    public @NonNull String getElementID() {
        return this.elementID;
    }

    @Override
    public @Nullable Frequency getMinFrequency() {
        return Frequency.parse((String)this.constraints.get(MIN_FREQ));
    }

    @Override
    public @Nullable Frequency getMaxFrequency() {
        return Frequency.parse((String)this.constraints.get(MAX_FREQ));
    }

    @Override
    public @Nullable Frequency getFrequency() {
        return Frequency.parse((String)this.constraints.get("freq"));
    }

    @Override
    public @Nullable Frequency getMinFrequencyWithAccuracy() {
        Frequency freq = this.getMinFrequency();
        BigRational accuracyLoc = this.accuracy;
        if (accuracyLoc != null) {
            Frequency accuracyFrequency = this.getAccuracyFrequency(freq);
            if (accuracyFrequency == null) {
                return null;
            }
            BigRational valueWithAccuracy = accuracyFrequency.getValue().multiply(BigRational.ONE.subtract(accuracyLoc));
            return new Frequency(valueWithAccuracy, accuracyFrequency.getUnit());
        }
        return freq;
    }

    @Override
    public @Nullable Frequency getMaxFrequencyWithAccuracy() {
        Frequency freq = this.getMaxFrequency();
        BigRational accuracyLoc = this.accuracy;
        if (accuracyLoc != null) {
            Frequency accuracyFrequency = this.getAccuracyFrequency(freq);
            if (accuracyFrequency == null) {
                return null;
            }
            BigRational valueWithAccuracy = accuracyFrequency.getValue().multiply(BigRational.ONE.add(accuracyLoc));
            return new Frequency(valueWithAccuracy, accuracyFrequency.getUnit());
        }
        return freq;
    }

    @Override
    public @Nullable Frequency getFrequencyWithAccuracy() {
        if (this.accuracy != null) {
            return null;
        }
        return this.getFrequency();
    }

    @Override
    public @Nullable FrequencyRange getAccuracyRangeOfExactFrequency() {
        Frequency exactFreq = this.getFrequency();
        if (exactFreq == null) {
            return null;
        }
        BigRational exactValue = FrequencyCalculator.toHertz((Frequency)exactFreq).getValue();
        BigRational accuracyLoc = this.accuracy;
        if (accuracyLoc == null) {
            return new FrequencyRange(exactValue, exactValue);
        }
        BigRational change = exactValue.multiply(accuracyLoc);
        BigRational minCap = exactValue.subtract(change);
        BigRational maxCap = exactValue.add(change);
        return new FrequencyRange(minCap, maxCap);
    }

    private @Nullable Frequency getAccuracyFrequency(@Nullable Frequency freq) {
        Frequency result = freq;
        if (freq == null) {
            result = this.getFrequency();
        }
        return result;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @Nullable List<@NonNull FrequencyRange> getFrequencyRanges() {
        String frequencies = this.constraints.get("freq_range");
        if (frequencies != null) {
            @NonNull List ranges = (List)Pattern.compile(";", 16).splitAsStream(frequencies).map(Constraint::createRange).collect(CollectorsUtils.toList());
            return new ArrayList<FrequencyRange>(ranges);
        }
        return null;
    }

    @Override
    public @Nullable List<@NonNull FrequencyRange> getFrequencyRangesWithAccuracy() {
        List<@NonNull FrequencyRange> ranges = this.getFrequencyRanges();
        BigRational accuracyLoc = this.accuracy;
        if (ranges == null || accuracyLoc == null) {
            return ranges;
        }
        return (List)ranges.stream().map(x -> FrequencyRange.modifyByAccuracy((FrequencyRange)x, (BigRational)accuracyLoc)).collect(CollectorsUtils.toList());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull FrequencyRange createRange(@NonNull String input) throws IllegalArgumentException {
        String value = input.trim();
        Frequency freq = Frequency.parse((String)value);
        if (freq != null) {
            return new FrequencyRange(Converter.toHertz(freq), Converter.toHertz(freq));
        }
        @NonNull List frequencies = (List)Pattern.compile("..", 16).splitAsStream(value).map(x -> Frequency.parseNonNull((String)x.trim())).collect(CollectorsUtils.toList());
        if (frequencies.size() == 2) {
            Frequency minFreq = (Frequency)frequencies.get(0);
            Frequency maxFreq = (Frequency)frequencies.get(1);
            return new FrequencyRange(Converter.toHertz(minFreq), Converter.toHertz(maxFreq));
        }
        throw new IllegalArgumentException("Unsupported frequencies format for :" + input);
    }

    @Override
    public @NonNull String getDescription() {
        String message;
        String description = this.constraints.get("description");
        if (description != null) {
            return description;
        }
        List<@NonNull FrequencyRange> frequencyRanges = this.getFrequencyRanges();
        Frequency frequency = this.getFrequency();
        Frequency minFrequency = null;
        Frequency maxFrequency = null;
        if (frequencyRanges != null) {
            String type = this.isOnInput ? Messages.get().Constraint_Input : Messages.get().Constraint_Output;
            String ranges = Text.formatListOfFrequencyRanges(frequencyRanges);
            BigRational accuracyLoc = this.accuracy;
            message = accuracyLoc != null && accuracyLoc.compareTo(BigRational.ZERO) > 0 ? MessageFormat.format(Messages.get().Constraint_FrequencyMustBeInRangeWithAccuracy, type, ranges, accuracyLoc.toExactDecimalString()) : MessageFormat.format(Messages.get().Constraint_FrequencyMustBeInRange, type, ranges);
        } else {
            if (frequency != null) {
                minFrequency = frequency;
                maxFrequency = frequency;
            } else {
                minFrequency = this.getMinFrequency();
                maxFrequency = this.getMaxFrequency();
            }
            message = ErrorHelper.extractFrequencyErrorMessage(this.isOnInput, minFrequency, maxFrequency, this.accuracy);
        }
        return message != null ? message : this.toString();
    }

    @Override
    public @Nullable Frequency getDefaultFrequency() {
        return Frequency.parse((String)this.constraints.get(DEFAULT_FREQ));
    }

    @Override
    public @Nullable String getConstraintValue(@NonNull String name) {
        return this.constraints.get(name);
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    @Override
    public @Nullable Expression getRestriction() {
        return this.restriction;
    }

    @Override
    public void setRestriction(@Nullable Expression restriction) {
        this.restriction = restriction;
    }

    @Override
    public boolean isRestrictedConstraint() {
        return this.condition != null || this.restriction != null;
    }

    @Override
    public boolean isOnInput() {
        return this.isOnInput;
    }

    public @NonNull String toString() {
        return "Constraint [Element : " + this.elementID + "]  " + this.constraints.toString();
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public void setLevel(@NonNull String levelName) {
        this.level = Level.getLevel(levelName);
    }

    @Override
    public @Nullable BigRational getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(@NonNull BigRational accuracy) {
        this.accuracy = accuracy;
    }

    private @NonNull Collection<@NonNull PowerMode> findInfluencedPowerModes(@NonNull Collection<@NonNull SettingValue> powerModeValues) {
        HashSet<@NonNull PowerMode> result = new HashSet<PowerMode>();
        Expression restrictionLoc = this.restriction;
        if (restrictionLoc == null) {
            for (SettingValue settingValue : powerModeValues) {
                if (!(settingValue.getValue() instanceof PowerMode)) {
                    throw new IllegalArgumentException("powerModeValues should have type PowerMode");
                }
                result.add((PowerMode)settingValue.getValue());
            }
            return result;
        }
        for (SettingValue value : powerModeValues) {
            IValue isRestricted = restrictionLoc.resolve(new PowerModeContext((PowerMode)value.getValue()));
            if (!isRestricted.getType().equals((Object)IValue.Type.BOOLEAN) || !isRestricted.getBoolean() || !(value.getValue() instanceof PowerMode)) continue;
            result.add((PowerMode)value.getValue());
        }
        return result;
    }

    public @NonNull Collection<@NonNull PowerMode> getInfluencedPowerModes(@NonNull Collection<@NonNull SettingValue> availablePowerModes) {
        Collection<@NonNull PowerMode> influencedPowerModesLoc = this.influencedPowerModes;
        if (influencedPowerModesLoc == null) {
            this.influencedPowerModes = influencedPowerModesLoc = this.findInfluencedPowerModes(availablePowerModes);
        }
        return influencedPowerModesLoc;
    }

    @Override
    public boolean isViolatedBy(@NonNull Frequency frequency) {
        BigRational requiredValue = FrequencyCalculator.toHertz((Frequency)frequency).getValue();
        Frequency min = this.getMinFrequencyWithAccuracy();
        Frequency max = this.getMaxFrequencyWithAccuracy();
        Frequency exact = this.getFrequencyWithAccuracy();
        FrequencyRange exactRange = this.getAccuracyRangeOfExactFrequency();
        @Nullable List<@NonNull FrequencyRange> ranges = this.getFrequencyRangesWithAccuracy();
        return min != null && min.compareTo(frequency) > 0 || max != null && max.compareTo(frequency) < 0 || exact != null && !exact.equals((Object)frequency) || exactRange != null && !exactRange.isInRange(requiredValue) || ranges != null && ranges.stream().noneMatch(r -> r.isInRange(requiredValue));
    }

    public static enum Level {
        ERROR("error"),
        WARNING("warning");

        @NonNull
        private String value;

        private Level(String value) {
            this.value = value;
        }

        public static @NonNull Level getLevel(@NonNull String text) {
            Level[] levelArray = Level.values();
            int n = levelArray.length;
            int n2 = 0;
            while (n2 < n) {
                Level level = levelArray[n2];
                if (Objects.equals(level.getValue(), text)) {
                    return level;
                }
                ++n2;
            }
            LOGGER.warning(String.valueOf(text) + " constraint level not found! ERROR will be used instead");
            return ERROR;
        }

        public final @NonNull String getValue() {
            return this.value;
        }
    }
}

