/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data;

import com.nxp.swtools.clocks.data.ClockSliceUtils;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.Pin;
import com.nxp.swtools.clocks.ui.diagram.DiagramConnection;
import com.nxp.swtools.clocks.ui.diagram.Junction;
import com.nxp.swtools.clocks.ui.diagramsymbols.CompositeSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.DiagramSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.clocks.ui.diagramsymbols.InvisibleConnectionSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.Wire;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class DiagramData {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(DiagramData.class);
    @NonNull
    @NonNull Collection<@NonNull DiagramSymbol> mTopLevelSymbols = new HashSet<DiagramSymbol>();
    @NonNull
    @NonNull Collection<@NonNull DiagramSymbol> mAllSymbols = new HashSet<DiagramSymbol>();
    @NonNull
    @NonNull Collection<@NonNull DiagramSymbol> mSymbolsWithElement;
    @NonNull
    @NonNull Collection<@NonNull DiagramSymbol> mSymbolsWithPin;
    @NonNull
    @NonNull Collection<@NonNull DiagramSymbol> mSymbolsUnavailable;
    @NonNull
    @NonNull Collection<@NonNull DiagramSymbol> mSymbolsDiagramOnly;
    @NonNull
    @NonNull Map<@NonNull String, @NonNull DiagramConnection> mConnections = new HashMap<String, DiagramConnection>();
    @NonNull
    @NonNull CollectionMap<@NonNull String, @NonNull DiagramConnection> mConnectionsFrom;
    @NonNull
    @NonNull CollectionMap<@NonNull String, @NonNull DiagramConnection> mConnectionsTo;
    public static final double ALLOWED_DISTANCE = 0.01;
    private boolean mSlice = false;

    public DiagramData(@NonNull Collection<@NonNull DiagramSymbol> diagramSymbols, @NonNull IMcu mcu, boolean slice) {
        this();
        this.mSlice = slice;
        this.mAllSymbols = diagramSymbols;
        this.mTopLevelSymbols = this.computeHierarchy();
        this.computeConnections();
        ArrayList<@NonNull E> tmp = new ArrayList();
        this.mAllSymbols.forEach(x -> {
            IClockElement element = mcu.getClockElement(x.getId());
            if (element != null) {
                if (element instanceof ClockOutput) {
                    tmp.add(x);
                } else {
                    this.mSymbolsWithElement.add((DiagramSymbol)x);
                }
                return;
            }
            boolean isUnavailable = mcu.isElementNotAvailable(x.getId());
            if (isUnavailable) {
                this.mSymbolsUnavailable.add((DiagramSymbol)x);
                return;
            }
            Pin p = mcu.getAllPins().get(x.getId());
            if (p != null) {
                this.mSymbolsWithPin.add((DiagramSymbol)x);
                return;
            }
            if (x.isDiagramOnly() && !x.getId().equals("Wires") && !x.getId().equals("Junctions")) {
                this.mSymbolsDiagramOnly.add((DiagramSymbol)x);
            }
        });
        this.mSymbolsWithElement.addAll(tmp);
        this.computeInterdiagramConnections(mcu);
    }

    public DiagramData(@NonNull Collection<@NonNull DiagramSymbol> diagramSymbols, @NonNull IMcu mcu) {
        this(diagramSymbols, mcu, false);
    }

    public DiagramData() {
        this.mSymbolsWithElement = new ArrayList<DiagramSymbol>();
        this.mSymbolsWithPin = new ArrayList<DiagramSymbol>();
        this.mSymbolsUnavailable = new ArrayList<DiagramSymbol>();
        this.mSymbolsDiagramOnly = new ArrayList<DiagramSymbol>();
        this.mConnectionsFrom = CollectionMap.createHashMapHashSet();
        this.mConnectionsTo = CollectionMap.createHashMapHashSet();
    }

    public @NonNull Collection<@NonNull DiagramSymbol> getTopLevelSymbols() {
        return this.mTopLevelSymbols;
    }

    public static void removeUnwantedJunctions(double allowedDistance, @NonNull Collection<@NonNull DiagramSymbol> symbols) {
        DiagramSymbol junctionSymbol = symbols.stream().filter(x -> x.getId().equals("Junctions")).findFirst().orElse(new CompositeSymbol("", false, false, false, false));
        Collection junctions = CollectionsUtils.getInstancesOf(junctionSymbol.getGraphElems(), Junction.class).collect(Collectors.toList());
        Collection teleports = CollectionsUtils.getInstancesOf(symbols, InvisibleConnectionSymbol.class).collect(Collectors.toList());
        ArrayList toRemove = new ArrayList();
        teleports.forEach(x -> {
            com.nxp.swtools.clocks.ui.diagramsymbols.Pin p = x.getInputPin();
            toRemove.addAll(junctions.stream().filter(y -> y.getPosition().distance(p.getStartDS()) <= allowedDistance || y.getPosition().distance(p.getEndDS()) <= allowedDistance).collect(Collectors.toList()));
        });
        junctionSymbol.getGraphElems().removeAll(toRemove);
    }

    private @NonNull List<@NonNull DiagramSymbol> computeHierarchy() {
        List<@NonNull T> boundaries = CollectionsUtils.getInstancesOf(this.mAllSymbols, CompositeSymbol.class).filter(CompositeSymbol::definesBoundary).collect(Collectors.toList());
        ArrayList<@NonNull DiagramSymbol> result = new ArrayList<DiagramSymbol>(this.mAllSymbols);
        for (CompositeSymbol cs : boundaries) {
            for (DiagramSymbol s : this.mAllSymbols) {
                if (cs.equals(s) || boundaries.contains(s) || !cs.isSurrounding(s)) continue;
                cs.addPart(s);
                s.setParent(cs);
                result.remove(s);
            }
        }
        return result;
    }

    private void computeConnections() {
        HashMap<com.nxp.swtools.clocks.ui.diagramsymbols.Pin, DiagramSymbol> elements = new HashMap<com.nxp.swtools.clocks.ui.diagramsymbols.Pin, DiagramSymbol>();
        ArrayList<@NonNull com.nxp.swtools.clocks.ui.diagramsymbols.Pin> outPins = new ArrayList<com.nxp.swtools.clocks.ui.diagramsymbols.Pin>();
        ArrayList<@NonNull com.nxp.swtools.clocks.ui.diagramsymbols.Pin> inPins = new ArrayList<com.nxp.swtools.clocks.ui.diagramsymbols.Pin>();
        for (DiagramSymbol symbol : this.mAllSymbols) {
            for (GraphicalElement element : symbol.getGraphElems()) {
                if (!(element instanceof com.nxp.swtools.clocks.ui.diagramsymbols.Pin)) continue;
                com.nxp.swtools.clocks.ui.diagramsymbols.Pin pin = (com.nxp.swtools.clocks.ui.diagramsymbols.Pin)element;
                if (pin.isInput()) {
                    inPins.add(pin);
                } else {
                    outPins.add(pin);
                }
                elements.put(pin, symbol);
            }
        }
        Collection<Wire> wires = this.getWires();
        for (com.nxp.swtools.clocks.ui.diagramsymbols.Pin pin : outPins) {
            Collection<DiagramConnection> pinConnections = this.findConnections(inPins, wires, pin, elements);
            for (DiagramConnection pinConnection : pinConnections) {
                DiagramSymbol succ = pinConnection.getSuccessor();
                if (succ != null && pinConnection.getPredecessor().getId().equals(succ.getId())) continue;
                this.addConnection(pinConnection);
            }
        }
    }

    private void addConnection(@NonNull DiagramConnection connection) {
        DiagramConnection prevVal = this.mConnections.put(connection.getId(), connection);
        if (prevVal != null) {
            this.mConnectionsFrom.removeItem((Object)connection.getPredecessorId(), (Object)prevVal);
            this.mConnectionsTo.removeItem((Object)connection.getSuccessorId(), (Object)prevVal);
        }
        this.mConnectionsFrom.add((Object)connection.getPredecessorId(), (Object)connection);
        this.mConnectionsTo.add((Object)connection.getSuccessorId(), (Object)connection);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void computeInterdiagramConnections(@NonNull IMcu mcu) {
        DiagramConnection foundConnection;
        if (!this.mSlice) {
            return;
        }
        @NonNull List sliceTeleports = (List)this.mSymbolsDiagramOnly.stream().filter(x -> x instanceof InvisibleConnectionSymbol && !((InvisibleConnectionSymbol)x).isInput()).collect(CollectorsUtils.toList());
        @NonNull List inputSliceTeleportIDs = (List)this.mSymbolsDiagramOnly.stream().filter(x -> x instanceof InvisibleConnectionSymbol && ((InvisibleConnectionSymbol)x).isInput()).map(DiagramSymbol::getId).collect(CollectorsUtils.toList());
        DiagramData mcuData = mcu.getDiagramDataCopy();
        @NonNull List mcuTeleports = (List)mcuData.mSymbolsDiagramOnly.stream().filter(x -> x instanceof InvisibleConnectionSymbol && !((InvisibleConnectionSymbol)x).isInput() && inputSliceTeleportIDs.contains(x.getId())).collect(CollectorsUtils.toList());
        HashMap<@NonNull String, @Nullable DiagramSymbol> sliceTeleportsWithInputKeys = new HashMap<String, DiagramSymbol>();
        HashMap<@NonNull String, @Nullable DiagramSymbol> mcuInputsWithInputKeys = new HashMap<String, DiagramSymbol>();
        HashMap<@NonNull String, @Nullable DiagramSymbol> mcuTeleportsWithInputKeys = new HashMap<String, DiagramSymbol>();
        HashMap<@NonNull String, @Nullable DiagramSymbol> sliceInputsWithInputKeys = new HashMap<String, DiagramSymbol>();
        for (DiagramSymbol teleport : sliceTeleports) {
            foundConnection = (DiagramConnection)CollectionsUtils.firstOrNull(mcuData.getConnectionsEndingIn(teleport.getId()));
            if (foundConnection == null) continue;
            sliceTeleportsWithInputKeys.put(foundConnection.getPredecessor().getId(), teleport);
            mcuInputsWithInputKeys.put(foundConnection.getPredecessor().getId(), foundConnection.getPredecessor());
        }
        for (DiagramSymbol teleport : mcuTeleports) {
            foundConnection = (DiagramConnection)CollectionsUtils.firstOrNull(this.getConnectionsEndingIn(teleport.getId()));
            if (foundConnection == null) continue;
            mcuTeleportsWithInputKeys.put(foundConnection.getPredecessor().getId(), teleport);
            sliceInputsWithInputKeys.put(foundConnection.getPredecessor().getId(), foundConnection.getPredecessor());
        }
        DiagramData.createNewConnections(mcuData, this, sliceTeleportsWithInputKeys, mcuInputsWithInputKeys);
        DiagramData.createNewConnections(this, mcuData, mcuTeleportsWithInputKeys, sliceInputsWithInputKeys);
    }

    private static void createNewConnections(@NonNull DiagramData inputData, @NonNull DiagramData outputData, @NonNull Map<@NonNull String, @Nullable DiagramSymbol> teleportsWithInputKeys, @NonNull Map<@NonNull String, @Nullable DiagramSymbol> inputsWithInputKeys) {
        for (Map.Entry<String, DiagramSymbol> entry : teleportsWithInputKeys.entrySet()) {
            String inputID = entry.getKey();
            DiagramSymbol foundTeleportSymbol = entry.getValue();
            DiagramSymbol foundInputSymbol = inputsWithInputKeys.get(inputID);
            if (foundTeleportSymbol == null || foundInputSymbol == null) continue;
            InvisibleConnectionSymbol foundTeleport = (InvisibleConnectionSymbol)foundTeleportSymbol;
            DiagramConnection inputTeleportConnection = inputData.getConnection(inputID, foundTeleport.getId());
            if (inputTeleportConnection == null) {
                LOGGER.log(Level.SEVERE, "Connection between input {0} and teleport {1} was not found. This cant happen, since they were paired by this connection.", new String[]{inputID, foundTeleport.getId()});
                continue;
            }
            DiagramConnection newConnection = new DiagramConnection(inputTeleportConnection.getPredPin(), foundInputSymbol);
            newConnection.setSuccessor(foundTeleport);
            newConnection.setSuccessorPin(foundTeleport.getInputPin());
            outputData.addConnection(newConnection);
            if (!inputData.mSlice && !inputData.mConnections.containsKey(newConnection.getId())) {
                inputData.addConnection(newConnection.makeCopy());
            }
            for (DiagramConnection oldTeleportConnection : outputData.getConnections(foundTeleport.getId())) {
                newConnection = new DiagramConnection(foundTeleport.getOutputPin(), foundInputSymbol);
                DiagramSymbol symbol = oldTeleportConnection.getSuccessor();
                if (symbol == null) continue;
                newConnection.setSuccessor(symbol);
                newConnection.setSuccessorPin(oldTeleportConnection.getSuccPin());
                outputData.addConnection(newConnection);
                inputData.addConnection(newConnection.makeCopy());
                if (outputData.getConnection(inputID, symbol.getId()) == null) {
                    LOGGER.log(Level.SEVERE, "Required connection between input {0} and symbol {1} is missing.", new String[]{inputID, symbol.getId()});
                    continue;
                }
                newConnection = new DiagramConnection(foundTeleport.getOutputPin(), oldTeleportConnection.getPredecessor());
                newConnection.setSuccessor(oldTeleportConnection.getSuccessor());
                newConnection.setSuccessorPin(oldTeleportConnection.getSuccPin());
                inputData.addConnection(newConnection);
            }
        }
    }

    private @NonNull Collection<Wire> getWires() {
        return (Collection)this.mAllSymbols.stream().flatMap(x -> x.getGraphElems().stream().filter(y -> y instanceof Wire).map(Wire.class::cast)).collect(CollectorsUtils.toList());
    }

    private @NonNull Collection<DiagramConnection> findConnections(@NonNull Collection<com.nxp.swtools.clocks.ui.diagramsymbols.Pin> inputPins, @NonNull Collection<Wire> wires, @NonNull com.nxp.swtools.clocks.ui.diagramsymbols.Pin outputPin, @NonNull Map<com.nxp.swtools.clocks.ui.diagramsymbols.Pin, DiagramSymbol> elements) {
        DiagramSymbol outElement = elements.get(outputPin);
        assert (outElement != null);
        DiagramConnection connection = new DiagramConnection(outputPin, outElement);
        Collection<DiagramConnection> result = this.updateConnection(inputPins, wires, outputPin.getEndDS(), connection, elements);
        if (result.isEmpty()) {
            result = this.updateConnection(inputPins, wires, outputPin.getStartDS(), connection, elements);
        }
        return result;
    }

    private @NonNull Collection<DiagramConnection> updateConnection(@NonNull Collection<com.nxp.swtools.clocks.ui.diagramsymbols.Pin> inputPins, @NonNull Collection<Wire> wires, @NonNull Point2D point, @NonNull DiagramConnection connection, @NonNull Map<com.nxp.swtools.clocks.ui.diagramsymbols.Pin, DiagramSymbol> elements) {
        ArrayList<DiagramConnection> result = new ArrayList<DiagramConnection>();
        List<Wire> matchingWires = DiagramData.getMatchingWires(point, wires);
        List<com.nxp.swtools.clocks.ui.diagramsymbols.Pin> matchingInputPins = DiagramData.getMatchingPins(point, inputPins);
        wires.removeAll(matchingWires);
        inputPins.removeAll(matchingInputPins);
        int elementsToInspect = matchingWires.size() + matchingInputPins.size();
        for (Wire wire : matchingWires) {
            Point2D nextPoint = wire.getEndDS().distance(point) < wire.getStartDS().distance(point) ? wire.getStartDS() : wire.getEndDS();
            DiagramConnection connectionCopy = elementsToInspect <= 1 ? connection : connection.makeCopy();
            connectionCopy.getWires().add(wire);
            result.addAll(this.updateConnection(inputPins, wires, nextPoint, connectionCopy, elements));
            --elementsToInspect;
        }
        for (com.nxp.swtools.clocks.ui.diagramsymbols.Pin pin : matchingInputPins) {
            connection.setSuccessorPin(pin);
            DiagramSymbol inElement = elements.get(pin);
            assert (inElement != null);
            connection.setSuccessor(inElement);
            result.add(elementsToInspect <= 1 ? connection : connection.makeCopy());
            --elementsToInspect;
        }
        return result;
    }

    protected static @NonNull List<@NonNull Wire> getMatchingWires(@NonNull Point2D point, @NonNull Collection<Wire> wires) {
        ArrayList<@NonNull Wire> matchingWires = new ArrayList<Wire>();
        for (Wire wire : wires) {
            if (!(wire.getEndDS().distance(point) <= 0.01) && !(wire.getStartDS().distance(point) <= 0.01)) continue;
            matchingWires.add(wire);
        }
        return matchingWires;
    }

    protected static @NonNull List<@NonNull com.nxp.swtools.clocks.ui.diagramsymbols.Pin> getMatchingPins(@NonNull Point2D point, @NonNull Collection<com.nxp.swtools.clocks.ui.diagramsymbols.Pin> pins) {
        ArrayList<@NonNull com.nxp.swtools.clocks.ui.diagramsymbols.Pin> matchingPins = new ArrayList<com.nxp.swtools.clocks.ui.diagramsymbols.Pin>();
        for (com.nxp.swtools.clocks.ui.diagramsymbols.Pin pin : pins) {
            if (!(pin.getEndDS().distance(point) <= 0.01) && !(pin.getStartDS().distance(point) <= 0.01)) continue;
            matchingPins.add(pin);
        }
        return matchingPins;
    }

    public @Nullable DiagramConnection getConnection(@NonNull String fromId, @NonNull String toId) {
        return this.mConnections.get(DiagramConnection.createConnectionID(fromId, toId));
    }

    public @NonNull Collection<@NonNull DiagramConnection> getConnections(@NonNull String fromId) {
        return CollectionsUtils.safeCollection((Collection)this.mConnectionsFrom.get((Object)fromId));
    }

    public @NonNull Collection<@NonNull DiagramConnection> getConnectionsEndingIn(@NonNull String toId) {
        return CollectionsUtils.safeCollection((Collection)this.mConnectionsTo.get((Object)toId));
    }

    public @NonNull Collection<@NonNull DiagramConnection> getAllConnections() {
        return this.mConnections.values();
    }

    public @NonNull Collection<@NonNull DiagramSymbol> getAllSymbols() {
        return this.mAllSymbols;
    }

    public @NonNull Collection<@NonNull DiagramSymbol> getSymbolsWithElement() {
        return this.mSymbolsWithElement;
    }

    public @NonNull Collection<@NonNull DiagramSymbol> getSymbolsWithPin() {
        return this.mSymbolsWithPin;
    }

    public @NonNull Collection<@NonNull DiagramSymbol> getSymbolsUnavailable() {
        return this.mSymbolsUnavailable;
    }

    public @NonNull Collection<@NonNull DiagramSymbol> getSymbolsDiagramOnly() {
        return this.mSymbolsDiagramOnly;
    }

    public boolean isSlice() {
        return this.mSlice;
    }

    public static void checkDiagramIntegrity(@NonNull IMcu mcu) {
        ArrayList<@NonNull DiagramData> dataToBeConfirmed = new ArrayList<DiagramData>();
        dataToBeConfirmed.add(mcu.getDiagramDataCopy());
        ClockSliceUtils.getAllClockSlices(mcu).forEach(x -> {
            boolean bl = dataToBeConfirmed.add(x.getDiagramData(mcu));
        });
        for (DiagramData data : dataToBeConfirmed) {
            for (DiagramSymbol symbol : data.getSymbolsDiagramOnly()) {
                InvisibleConnectionSymbol teleport;
                int connectionCount;
                if (!(symbol instanceof InvisibleConnectionSymbol) || (connectionCount = data.getConnectionsEndingIn((teleport = (InvisibleConnectionSymbol)symbol).getId()).size()) == 1) continue;
                LOGGER.severe(MessageFormat.format("Teleport with ID {0} has {1} input connections, while exactly 1 input connection expected.", symbol.getId(), connectionCount));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public @Nullable InvisibleConnectionSymbol getTeleportConnectedTo(@NonNull String signal) {
        String elementId = signal.endsWith(".clk") ? signal.substring(0, signal.lastIndexOf(".clk")) : signal;
        Optional<@NonNull DiagramSymbol> symbol = this.getSymbolsWithElement().stream().filter(x -> elementId.equals(x.getId())).findAny();
        ArrayList<@NonNull DiagramSymbol> predecessors = new ArrayList<DiagramSymbol>();
        if (!symbol.isPresent()) {
            return null;
        }
        predecessors.add(symbol.get());
        while (!predecessors.isEmpty()) {
            ArrayList<@NonNull DiagramSymbol> nextSymbols = new ArrayList<DiagramSymbol>();
            for (DiagramSymbol predecessor : predecessors) {
                Collection<@NonNull DiagramConnection> connections = this.getConnections(predecessor.getId());
                for (DiagramConnection connection : connections) {
                    DiagramSymbol successor = connection.getSuccessor();
                    if (successor instanceof InvisibleConnectionSymbol && ((InvisibleConnectionSymbol)successor).isInput()) {
                        return (InvisibleConnectionSymbol)successor;
                    }
                    if (successor == null) continue;
                    nextSymbols.add(successor);
                }
            }
            predecessors = nextSymbols;
        }
        return null;
    }
}

