/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.dependencies;

import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.BitFieldSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import java.util.Collection;
import java.util.Comparator;

public class PriorityComparator
implements Comparator<String> {
    @NonNull
    private final IClocksConfig config;
    @Nullable
    private final ISetting prioritizedSetting;
    @NonNull
    private final @NonNull Collection<@NonNull String> unprioritizedSettings;

    public PriorityComparator(@NonNull IClocksConfig config, @Nullable ISetting prioritizedSetting, @NonNull Collection<@NonNull String> unprioritizedSettings) {
        this.config = config;
        this.prioritizedSetting = prioritizedSetting;
        this.unprioritizedSettings = unprioritizedSettings;
    }

    @Override
    public int compare(@NonNull String o1, @NonNull String o2) {
        return PriorityComparator.getPriority(o1, this.config, this.prioritizedSetting, this.unprioritizedSettings) - PriorityComparator.getPriority(o2, this.config, this.prioritizedSetting, this.unprioritizedSettings);
    }

    public int getPriority(@NonNull String settingId) {
        return PriorityComparator.getPriority(settingId, this.config, this.prioritizedSetting, this.unprioritizedSettings);
    }

    public static int getPriority(@NonNull String settingId, @NonNull IClocksConfig config, @Nullable ISetting prioritizedSetting, @NonNull Collection<@NonNull String> unprioritizedSettings) {
        if (unprioritizedSettings.contains(settingId)) {
            return 400;
        }
        ISetting setting = config.getMcu().getSettings().findSettingWithId(settingId);
        int priority = 0;
        if (setting != null) {
            if (setting.getType() == SettingType.GLOBAL_CONFIG_ELEMENT) {
                priority = 900;
            } else if (setting.getType() == SettingType.LOCAL_CONFIG_ELEMENT) {
                priority = 800;
            } else if (setting.isUserLockable() && config.getSettingsConfig().isLocked(setting)) {
                priority = 700;
                if (setting instanceof BitFieldSetting) {
                    priority += 275;
                }
            } else {
                priority = setting.getType() != SettingType.BIT_FIELD ? 600 : 500;
            }
            if (setting.isPrioritized()) {
                priority += 50;
            }
            if (setting == prioritizedSetting) {
                priority += 1000;
            }
        }
        return priority;
    }
}

