/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.BitFieldAssign;
import com.nxp.swtools.clocks.data.elements.ClocksBitFieldProvider;
import com.nxp.swtools.clocks.data.elements.IConfigElementItem;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.expression.ConfigContext;
import com.nxp.swtools.clocks.expression.DefaultContext;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.BitFieldVariable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.expression.WrappedContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ConfigElementItem
implements IConfigElementItem {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(ConfigElementItem.class);
    @NonNull
    private String id;
    @NonNull
    private String description;
    @Nullable
    private String longDescription;
    @NonNull
    private @NonNull Map<@NonNull String, @NonNull BitFieldAssign> assigns;
    @NonNull
    private @NonNull Map<@NonNull String, @NonNull Expression> conditions;
    @Nullable
    private String reverseExpr;

    public ConfigElementItem(@NonNull String id, @NonNull String description, @NonNull Map<@NonNull String, @NonNull BitFieldAssign> assigns, @NonNull Map<@NonNull String, @NonNull Expression> conditions, @Nullable String longDescription) {
        this.id = id;
        this.description = description;
        this.assigns = assigns;
        this.conditions = conditions;
        this.longDescription = longDescription;
    }

    public ConfigElementItem(@NonNull String id, @NonNull String description, @NonNull Map<@NonNull String, @NonNull BitFieldAssign> assigns, @NonNull Map<@NonNull String, @NonNull Expression> conditions, @Nullable String longDescription, @NonNull String reverseExpr) {
        this(id, description, assigns, conditions, longDescription);
        this.reverseExpr = reverseExpr.isEmpty() ? null : reverseExpr;
    }

    @Override
    public @NonNull String getID() {
        return this.id;
    }

    @Override
    public @NonNull String getName() {
        return this.description;
    }

    @Override
    public @Nullable String getDescription() {
        return this.longDescription;
    }

    @Override
    public @Nullable Collection<@NonNull Constraint> getConstraints() {
        return new ArrayList<Constraint>();
    }

    @Override
    public @NonNull Collection<@NonNull String> getUsedBitFields() {
        return CollectionsUtils.unmodifiableCollection(this.assigns.keySet());
    }

    @Override
    public @NonNull Map<@NonNull String, @NonNull Long> getBitFieldsToAssignForConfig(@NonNull IClocksConfig config) {
        HashMap<@NonNull String, @NonNull Long> activeAssigns = new HashMap<String, Long>();
        ConfigContext configContext = new ConfigContext(DefaultContext.getInstance(), config);
        WrappedContext ctx = new WrappedContext((IContext)configContext);
        List<BitFieldAssign> orderedAssigns = this.getOrderedAssigns(config);
        for (BitFieldAssign assign : orderedAssigns) {
            if (assign != null) {
                List<@NonNull Expression> assignConditions = assign.getConditions();
                List<@NonNull Expression> valueExpressions = assign.getValueExpressions();
                int i = 0;
                while (i < assignConditions.size()) {
                    Expression valueExpression;
                    IValue valueExpressionResult;
                    boolean isActive = true;
                    Expression expression = assignConditions.get(i);
                    isActive = expression.resolve(config).getBoolean();
                    if (isActive && !(valueExpressionResult = (valueExpression = valueExpressions.get(i)).resolve((IContext)ctx)).getValue().equals("N/A")) {
                        BigInteger value = ConfigElementItem.getAssignValue(valueExpressionResult, assign, configContext, config);
                        ctx.defineSetting(assign.getBitFieldID(), (Object)value);
                        activeAssigns.put(assign.getBitFieldID(), new Long(value.longValue()));
                    }
                    ++i;
                }
                continue;
            }
            LOGGER.severe("Assign value should not be null");
        }
        return activeAssigns;
    }

    private @NonNull List<BitFieldAssign> getOrderedAssigns(@NonNull IClocksConfig config) {
        ArrayList<BitFieldAssign> orderedAssigns = new ArrayList<BitFieldAssign>();
        for (Map.Entry<String, BitFieldAssign> assignEntry : this.assigns.entrySet()) {
            BitFieldAssign assign = assignEntry.getValue();
            if (assign == null) continue;
            Expression expression = assign.getActiveExpression(config);
            if (expression == null || expression.getBitFields().isEmpty()) {
                orderedAssigns.add(assign);
                continue;
            }
            for (Map.Entry<String, BitFieldAssign> searchedAssignEntry : this.assigns.entrySet()) {
                Expression searchedValueExpression;
                BitFieldAssign searchedAssign = searchedAssignEntry.getValue();
                if (searchedAssign == null || (searchedValueExpression = searchedAssign.getActiveExpression(config)) == null || assign.equals(searchedAssign)) continue;
                if (searchedValueExpression.getBitFields().stream().anyMatch(val -> assign.getBitFieldID().equals(String.valueOf(val.getRegisterName()) + "[" + val.getBitFieldName() + "]"))) {
                    orderedAssigns.add(0, assign);
                    continue;
                }
                orderedAssigns.add(assign);
            }
        }
        return orderedAssigns;
    }

    @Override
    public @NonNull Collection<@NonNull String> getDependencies(@NonNull IMcu mcu) {
        HashSet<@NonNull String> dependencies = new HashSet<String>();
        this.conditions.values().forEach(x -> {
            boolean bl = dependencies.addAll(x.getSettings());
        });
        for (Map.Entry<String, BitFieldAssign> bits : this.assigns.entrySet()) {
            bits.getValue().getValueExpressions().forEach(exp -> {
                dependencies.addAll(exp.getSettings());
                List<@NonNull @NonNull BitFieldVariable> bitList = exp.getBitFields();
                for (BitFieldVariable field : bitList) {
                    dependencies.add(SettingProvider.getBitFieldSettingID(String.valueOf(field.getRegisterName()) + "[" + field.getBitFieldName() + "]"));
                }
            });
        }
        Collection<@NonNull String> bitList = this.getUsedBitFields();
        for (String field : bitList) {
            dependencies.remove(SettingProvider.getBitFieldSettingID(field));
        }
        return dependencies;
    }

    @Override
    public @NonNull Collection<@NonNull String> getUsedSettings() {
        HashSet<@NonNull String> dependencies = new HashSet<String>();
        for (Map.Entry<String, BitFieldAssign> bits : this.assigns.entrySet()) {
            bits.getValue().getValueExpressions().forEach(x -> {
                boolean bl = dependencies.addAll(x.getSettings());
            });
        }
        return dependencies;
    }

    @Override
    public @Nullable String getReverseExpr() {
        return this.reverseExpr;
    }

    @Override
    public @NonNull Collection<@NonNull BitFieldAssign> getMaskedAssigns() {
        return this.assigns.values().stream().filter(x -> x.getMaskExpression() != null).collect(Collectors.toList());
    }

    private static BigInteger getAssignValue(IValue valueExpressionResult, BitFieldAssign assign, IContext context, IClocksConfig config) {
        BitFieldElement bitField;
        BigInteger value = valueExpressionResult.getRational().toBigIntegerRounded(false);
        Expression maskExpression = assign.getMaskExpression();
        String bitFieldID = assign.getBitFieldID();
        if (maskExpression != null && bitFieldID != null && (bitField = ClocksBitFieldProvider.getBitFieldById(bitFieldID, config.getMcu().getBitFieldsCache())) != null) {
            BigInteger bitFieldValue = BigInteger.valueOf(context.getBitFieldValue(bitField.getRegisterId(), bitField.getBitField().getName()));
            value = ConfigElementItem.calculateMaskedValue(bitFieldValue, value, maskExpression.resolve().getBigInteger());
        }
        return value;
    }

    @Override
    public @Nullable Long getMaskedValue(@NonNull String bitField, long value, @NonNull IClocksConfig config) {
        BitFieldAssign bitFieldAssign = this.assigns.get(bitField);
        if (bitFieldAssign != null) {
            Expression activeExpression = bitFieldAssign.getActiveExpression(config);
            Expression maskExpression = bitFieldAssign.getMaskExpression();
            if (maskExpression != null && activeExpression != null) {
                BigInteger bfValue = BigInteger.valueOf(value);
                BigInteger newValue = activeExpression.resolve().getBigInteger();
                return ConfigElementItem.calculateMaskedValue(bfValue, newValue, maskExpression.resolve().getBigInteger()).longValue();
            }
        }
        return null;
    }

    private static BigInteger calculateMaskedValue(BigInteger oldValue, BigInteger newValue, BigInteger mask) {
        return oldValue.and(mask.not()).or(newValue.and(mask));
    }
}

