/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.elements.BitFieldAssign;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.IPowerModeSpecificElement;
import com.nxp.swtools.clocks.data.elements.PowerMode;
import com.nxp.swtools.clocks.data.elements.PowerModeSpecificElement;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.FnPllConfigSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class FnPllConfigElement
implements IElement,
IPowerModeSpecificElement {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(FnPllConfigElement.class);
    @NonNull
    private String id;
    @NonNull
    private String name;
    @NonNull
    private String description;
    @NonNull
    private Range valuesRange;
    @NonNull
    private ISetting setting;
    @NonNull
    private EnableSetting enableSetting;
    @NonNull
    private String defaultValue;
    @NonNull
    private @NonNull Map<@NonNull String, BitFieldAssign> assigns;
    @NonNull
    private PowerModeSpecificElement powerModeSpecific;

    public FnPllConfigElement(@NonNull String id, @NonNull String name, @NonNull String description, @NonNull Range valuesRange, @NonNull String defaultValue, @NonNull Map<@NonNull String, BitFieldAssign> assigns) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue;
        this.valuesRange = valuesRange;
        this.enableSetting = new EnableSetting(name, this);
        this.setting = new FnPllConfigSetting(name, SettingType.LOCAL_CONFIG_ELEMENT, this);
        this.assigns = assigns;
        this.powerModeSpecific = new PowerModeSpecificElement(() -> new FnPllConfigSetting(name, SettingType.LOCAL_CONFIG_ELEMENT, this), Collections::emptyList);
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull String getID() {
        return this.id;
    }

    @Override
    public @Nullable String getDescription() {
        return this.description;
    }

    @Override
    public boolean isEnabled(@NonNull IClocksConfig config) {
        return true;
    }

    @Override
    public @NonNull EnableSetting getEnableSetting() {
        return this.enableSetting;
    }

    public @NonNull Range getRange() {
        return this.valuesRange;
    }

    public @NonNull ISetting getSetting() {
        return this.setting;
    }

    public @Nullable SettingValue getDefaultValue() {
        return new SettingValue(this.defaultValue);
    }

    public @NonNull Map<@NonNull ISetting, @NonNull SettingValue> getBitFieldsToWrite(@NonNull IClocksConfig config, @NonNull SettingValue value) {
        HashMap<@NonNull ISetting, @NonNull SettingValue> bitFieldSettings = new HashMap<ISetting, SettingValue>();
        this.assigns.forEach((k, v) -> {
            ISetting bitFieldSetting = SettingProvider.getBitFieldSetting(k, config.getMcu());
            if (bitFieldSetting != null) {
                Expression expression = v.getActiveExpression(config);
                if (expression == null) {
                    LOGGER.severe("No valid value expression (no value to assign) found for bit field: " + k);
                    return;
                }
                IValue resolve = expression.resolve(config);
                try {
                    bitFieldSettings.put(bitFieldSetting, new SettingValue(resolve.getRational().toBigInteger()));
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.severe(resolve.getRational() + " is not a valid bit field value");
                }
            } else {
                LOGGER.severe("No bit field setting found for bit field: " + k);
            }
        });
        return bitFieldSettings;
    }

    public @NonNull Collection<@NonNull String> getUsedBitFields() {
        return CollectionsUtils.unmodifiableCollection(this.assigns.keySet());
    }

    public @NonNull Collection<@NonNull String> getDependencies() {
        HashSet<@NonNull String> dependencies = new HashSet<String>();
        this.assigns.forEach((k, v) -> {
            HashSet<@NonNull E> settings = new HashSet();
            v.getValueExpressions().forEach(x -> {
                boolean bl = settings.addAll(x.getSettings());
            });
            @NonNull List collect = (List)settings.stream().filter(x -> !x.equals(this.id)).collect(CollectorsUtils.toList());
            dependencies.addAll(collect);
        });
        return dependencies;
    }

    public @NonNull Collection<@NonNull String> getAllControledSettings() {
        HashSet<@NonNull String> influenced = new HashSet<String>();
        this.assigns.keySet().forEach(x -> {
            boolean bl = influenced.add(SettingProvider.getBitFieldSettingID(x));
        });
        return influenced;
    }

    @Override
    public void setPowerModeSpecific(boolean isPowerModeSpecific) {
        this.powerModeSpecific.setPowerModeSpecific(isPowerModeSpecific);
    }

    @Override
    public boolean isPowerModeSpecific() {
        return this.powerModeSpecific.isPowerModeSpecific();
    }

    @Override
    public @NonNull Map<@NonNull String, @NonNull ISetting> createPowerModeSpecificSettings(@NonNull List<@NonNull PowerMode> powerModes) {
        return this.powerModeSpecific.createPowerModeSpecificSettings(powerModes);
    }

    @Override
    public @NonNull List<@NonNull ISetting> getPowerModeSpecificSettings() {
        return this.powerModeSpecific.getPowerModeSpecificSettings();
    }
}

