/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.elements.AClockModelCreationElement;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.ModelCreationI;
import com.nxp.swtools.clocks.model.ModelDataComI;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import java.util.ArrayList;

public class Splitter
implements ModelDataComI {
    @Nullable
    private Node node;
    @NonNull
    private ModelCreationI device;
    @NonNull
    String predecessor;
    @NonNull
    private String id;
    @NonNull
    @NonNull ArrayList<@NonNull String> successors;

    public Splitter(@NonNull String id, @NonNull String predecessor) {
        this.id = id;
        this.predecessor = predecessor;
        this.successors = new ArrayList();
        this.device = new SplitterElement(id);
    }

    public void addSuccessor(@NonNull String successor) {
        if (!this.successors.contains(successor)) {
            this.successors.add(successor);
        }
    }

    public @NonNull String getPredecessor() {
        return this.predecessor;
    }

    public @NonNull String getID() {
        return this.id;
    }

    public ModelCreationI getDevice() {
        return this.device;
    }

    public void setDevice(Node nd) {
        this.node = nd;
    }

    public @Nullable Node getComputationNode() {
        return this.node;
    }

    private class SplitterElement
    extends AClockModelCreationElement {
        public SplitterElement(String id) {
            super(id, ENodeType.Splitter);
        }

        @Override
        public String getPredecessor() {
            return Splitter.this.predecessor;
        }

        public ArrayList<String> getSuccList() {
            return Splitter.this.successors;
        }
    }
}

