/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.model;

import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldValueAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegParentPeripheralAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegisterAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.utils.registers.BitField;
import com.nxp.swtools.utils.registers.BitFieldProvider;
import java.math.BigInteger;

public class BitFieldElement
extends BitField
implements IRegBitFieldAPI,
IElement {
    public BitFieldElement(@NonNull BitField bitField) {
        this(bitField.getRegister(), bitField.getPeripheral(), bitField.getBitField());
    }

    public BitFieldElement(@NonNull IRegisterAPI register, @NonNull IRegParentPeripheralAPI peripheral, @NonNull IRegBitFieldAPI bitField) {
        super(register, peripheral, bitField);
    }

    public static @Nullable BitFieldElement valueOf(@NonNull String peripheral, @NonNull String register, @NonNull String bitField, @NonNull IRegistersDatabaseAPI registersDB) {
        IRegBitFieldAPI bitFieldAPI;
        IRegisterAPI registerAPI;
        IRegParentPeripheralAPI peripheralApi = BitFieldProvider.findPeripheral((String)peripheral, (IRegistersDatabaseAPI)registersDB);
        if (peripheralApi != null && (registerAPI = BitFieldProvider.findRegister((IRegParentPeripheralAPI)peripheralApi, (String)register)) != null && (bitFieldAPI = BitFieldProvider.findBitField((IRegisterAPI)registerAPI, (String)bitField)) != null) {
            return new BitFieldElement(registerAPI, peripheralApi, bitFieldAPI);
        }
        return null;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitFieldElement other = (BitFieldElement)obj;
        return this.getID().equals(other.getID());
    }

    public String toString() {
        return this.getID();
    }

    @Override
    public @NonNull String getName() {
        return this.bitField.getName();
    }

    public @Nullable String getAlias(@NonNull String typeName) {
        return this.bitField.getAlias(typeName);
    }

    public @NonNull String getSafeAlias(@NonNull String typeName) {
        return this.bitField.getSafeAlias(typeName);
    }

    public short getOffset() {
        return this.bitField.getOffset();
    }

    public short getWidth() {
        return this.bitField.getWidth();
    }

    public short getItemWidth() {
        return this.bitField.getItemWidth();
    }

    public Number getValueMask() {
        return this.bitField.getValueMask();
    }

    public @NonNull BigInteger getValueMaskAsBigInteger() {
        return this.bitField.getValueMaskAsBigInteger();
    }

    public Number getRegisterMask() {
        return this.bitField.getRegisterMask();
    }

    public @NonNull String getAccessId() {
        return this.bitField.getAccessId();
    }

    public @NonNull Number getResetMask() {
        return this.bitField.getResetMask();
    }

    public @NonNull BigInteger getResetMaskAsBigInteger() {
        return this.bitField.getResetMaskAsBigInteger();
    }

    public @NonNull Number getResetValue() {
        return this.bitField.getResetValue();
    }

    public @NonNull BigInteger getResetValueAsBigInteger() {
        return this.bitField.getResetValueAsBigInteger();
    }

    public @NonNull IRegBitFieldValueAPI @NonNull [] getValues() {
        return this.bitField.getValues();
    }

    public @Nullable IRegBitFieldValueAPI findValueByRegisterValue(BigInteger registerValue) {
        return this.bitField.findValueByRegisterValue(registerValue);
    }

    @Override
    public @NonNull String getDescription() {
        return this.bitField.getDescription();
    }

    public boolean isReserved() {
        return this.bitField.isReserved();
    }

    public boolean isReadOnly() {
        return this.bitField.isReadOnly();
    }

    public boolean isArray() {
        return this.bitField.isArray();
    }

    @Override
    public boolean isEnabled(@NonNull IClocksConfig config) {
        return true;
    }

    @Override
    public @Nullable EnableSetting getEnableSetting() {
        return null;
    }

    @Override
    public @NonNull String getID() {
        return this.getId();
    }

    public @Nullable Number getRomModifiedValue() {
        return this.bitField.getRomModifiedValue();
    }

    public @Nullable BigInteger getRomModifiedValueAsBigInteger() {
        return this.bitField.getRomModifiedValueAsBigInteger();
    }
}

