/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.settings;

import com.nxp.swtools.clocks.data.LongValues;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.ASetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.data.valueMaps.ValueMap;
import com.nxp.swtools.clocks.utils.ParenthesesType;
import com.nxp.swtools.clocks.utils.Text;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;

public abstract class AGeneralSetting
extends ASetting {
    protected boolean enabled = false;
    protected boolean editable = false;
    protected boolean visible = true;
    protected boolean editableByDefault = false;
    @NonNull
    protected final String name;
    @NonNull
    protected SettingType type;

    public AGeneralSetting(@NonNull String name, @NonNull SettingType type, @NonNull IElement element, boolean enabled, boolean editable, boolean visible) {
        super(element);
        this.name = name;
        this.enabled = enabled;
        this.editable = editable;
        this.editableByDefault = editable;
        this.visible = visible;
        this.type = type;
    }

    public AGeneralSetting(@NonNull String name, @NonNull SettingType type, @NonNull IElement element) {
        this(name, type, element, false, false, false);
    }

    @Override
    public boolean isValid(@NonNull SettingValue settingValue, @NonNull IClocksConfig clocksConfig) {
        return false;
    }

    protected boolean isElementValid(@NonNull IClocksConfig clocksConfig) {
        if (this.element instanceof IClockElement) {
            IClockElement elementLoc = (IClockElement)this.element;
            if (!elementLoc.isEnabledForModel(clocksConfig)) {
                return true;
            }
            return elementLoc.isValid(clocksConfig);
        }
        return true;
    }

    @Override
    public boolean isEnabled(IClocksConfig clocksConfig) {
        if (this.element instanceof IClockElement) {
            return ((IClockElement)this.element).isEnabled(clocksConfig);
        }
        if (this.element instanceof IConfigElement) {
            return ((IConfigElement)this.element).isEnabled(clocksConfig);
        }
        return this.enabled;
    }

    @Override
    public boolean isEditable(IClocksConfig clocksConfig) {
        return this.editable && clocksConfig.getSettingsConfig().isEditable(this);
    }

    @Override
    public boolean isEditableByDefault() {
        return this.editableByDefault;
    }

    @Override
    public String getName() {
        return this.powerMode != null ? String.valueOf(this.name) + " " + Text.wrapWithParentheses(this.powerMode, ParenthesesType.ROUND) : this.name;
    }

    @Override
    public boolean isVisible(@Nullable IClocksConfig config) {
        return this.visible && (config == null || config.getSettingsConfig().isVisible(this));
    }

    @Override
    public @NonNull String getId() {
        String elementID = this.element.getID();
        String id = String.valueOf(elementID) + "." + this.getIdSuffix();
        if (this.powerMode != null) {
            id = String.valueOf(this.powerMode) + ":" + id;
        }
        return id;
    }

    protected @NonNull String getIdSuffix() {
        return "";
    }

    @Override
    public @NonNull SettingType getType() {
        return this.type;
    }

    @Override
    public @Nullable SettingValue parseBfValue(@NonNull Object value, @NonNull IClocksConfig clocksConfig) {
        String uiValue;
        IClockElement elementLoc;
        ValueMap valueMap;
        if (this.element instanceof IClockElement && (valueMap = (elementLoc = (IClockElement)this.element).getActiveValueMap(clocksConfig)) != null && (uiValue = valueMap.getUiValueByBfValue(new LongValues((Long)value))) != null) {
            SettingValue parsedUiValue = this.parseUiValue(uiValue, clocksConfig);
            if (parsedUiValue != null) {
                return parsedUiValue;
            }
            Long longValue = Long.valueOf(uiValue);
            return this.parseValue(longValue, clocksConfig);
        }
        return null;
    }
}

