/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.settings;

import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.PowerMode;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.AGlobalSetting;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class PowerModeSetting
extends AGlobalSetting {
    @NonNull
    private @NonNull List<@NonNull SettingValue> powerModeValues = new ArrayList<SettingValue>();
    @NonNull
    public static final String SETTING_NAME = "powerMode";

    public PowerModeSetting(@NonNull List<@NonNull PowerMode> powerModes, final @Nullable String customPowerModesDescription) {
        super(new IElement(){

            @Override
            public @NonNull String getName() {
                return UtilsText.safeString((String)Messages.get().PowerModeSetting_PowerModeLabel);
            }

            @Override
            public @NonNull String getID() {
                return PowerModeSetting.SETTING_NAME;
            }

            @Override
            public boolean isEnabled(@NonNull IClocksConfig config) {
                return true;
            }

            @Override
            public @Nullable EnableSetting getEnableSetting() {
                return null;
            }

            @Override
            public @Nullable String getDescription() {
                if (customPowerModesDescription != null) {
                    return customPowerModesDescription;
                }
                return Messages.get().PowerModeSetting_Description;
            }
        });
        powerModes.forEach(x -> {
            boolean bl = this.powerModeValues.add(new SettingValue(x, x.getName()));
        });
    }

    @Override
    public @NonNull String getId() {
        return this.element.getID();
    }

    @Override
    public @NonNull String getName() {
        return this.element.getName();
    }

    @Override
    public @Nullable List<@NonNull SettingValue> getValues(@NonNull IClocksConfig clocksConfig) {
        return this.powerModeValues;
    }

    @Override
    public @Nullable SettingValue parseUiValue(@NonNull String uiValue, @NonNull IClocksConfig clocksConfig) {
        for (SettingValue settingVal : this.powerModeValues) {
            if (!settingVal.getUiValue().equals(uiValue)) continue;
            return settingVal;
        }
        return null;
    }

    @Override
    public boolean isValid(@NonNull SettingValue settingValue, @NonNull IClocksConfig clocksConfig) {
        return !settingValue.isN_A() && clocksConfig.getProblemsOfElement(this.getId(), 2).isEmpty();
    }

    @Override
    public @Nullable SettingValue getDefaultValue(IClocksConfig clockConfig) {
        Optional<SettingValue> def = this.powerModeValues.stream().filter(x -> {
            Object value = x.getValue();
            return value instanceof PowerMode && ((PowerMode)value).isDefault();
        }).findFirst();
        if (def.isPresent()) {
            return def.get();
        }
        LOGGER.severe("There is no default power mode. First available power mode will be used instead");
        return this.powerModeValues.get(0);
    }

    @Override
    public boolean isUserLockable() {
        return false;
    }

    @Override
    public boolean isLockedByDefault() {
        return true;
    }

    @Override
    public @Nullable SettingValue parseValue(@NonNull Object value, @NonNull IClocksConfig clocksConfig) {
        for (SettingValue settingVal : this.powerModeValues) {
            if (!settingVal.getValue().equals(value)) continue;
            return settingVal;
        }
        return null;
    }

    @Override
    public @Nullable SettingValue fromString(@NonNull String string, @NonNull IClocksConfig clocksConfig) {
        SettingValue result = this.parseUiValue(string, clocksConfig);
        if (result == null) {
            result = SettingValue.N_A;
        }
        return result;
    }

    @Override
    public @NonNull String toString(@NonNull SettingValue settingValue) {
        return settingValue.getUiValue();
    }

    @Override
    public boolean hasConflicts(@NonNull SettingValue value, @NonNull IClocksConfig clocksConfig) {
        return false;
    }

    @Override
    public @Nullable String getToolTipText(@NonNull SettingValue value, @NonNull IClocksConfig clocksConfig) {
        String description = null;
        Object settingValue = value.getValue();
        if (settingValue instanceof PowerMode) {
            description = ((PowerMode)settingValue).getDescription();
        }
        return description;
    }
}

