/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.expression;

import com.nxp.swtools.clocks.data.BitFieldsCache;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.expression.ARegistersContext;
import com.nxp.swtools.clocks.expression.DefaultContext;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.expert.processor.properties.PackageProperties;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.utils.registers.EmptyRegistersDB;

public class ComponentContext
extends ARegistersContext {
    @NonNull
    private String peripheral;
    @NonNull
    private String componentID;
    @Nullable
    private String filePath;
    private boolean isSlice;
    @NonNull
    private BitFieldsCache registers;
    @NonNull
    public static final ComponentContext MCU_CONTEXT = new ComponentContext("", "", new BitFieldsCache((IRegistersDatabaseAPI)EmptyRegistersDB.INSTANCE));

    public ComponentContext(@NonNull String peripheral, @NonNull String componentID, @NonNull BitFieldsCache registers) {
        this.peripheral = peripheral;
        this.componentID = componentID;
        this.registers = registers;
        this.isSlice = false;
    }

    @Override
    public @NonNull BitFieldsCache getRegisters() {
        return this.registers;
    }

    @Override
    public long getBitFieldValue(@NonNull String registerName, @NonNull String bitFieldName) {
        return super.getBitFieldValue(this.formatFullRegisterName(registerName), bitFieldName);
    }

    private @NonNull String formatFullRegisterName(String registerName) {
        String registerFullName = registerName.contains("::") ? registerName : String.valueOf(this.peripheral) + "::" + registerName;
        return registerFullName;
    }

    public @NonNull Object getSettingValue(@NonNull String settingName) {
        ICommonConfig commonConfig = SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig();
        Object propertyValue = PackageProperties.getProperty((String)settingName, (IMcuIdentification)commonConfig.getMcuIdentification());
        if (propertyValue != null) {
            return propertyValue;
        }
        String settingFullID = this.getSettingId(settingName);
        IContext defaultContext = DefaultContext.getInstance();
        IClocksProfile profile = UiController.getInstance().getProfile();
        IMcu mcu = profile.getMcu();
        ISetting setting = SettingProvider.getSettingById(settingFullID, mcu);
        return setting != null ? defaultContext.getSettingValue(settingFullID) : defaultContext.getSettingValue(settingName);
    }

    @Override
    public int getBitFiledWidth(@NonNull String registerName, @NonNull String bitFieldName) {
        return super.getBitFiledWidth(this.formatFullRegisterName(registerName), bitFieldName);
    }

    @Override
    public @NonNull String getBitFieldId(@NonNull String registerName, @NonNull String bitFieldName) {
        return super.getBitFieldId(this.formatFullRegisterName(registerName), bitFieldName);
    }

    public @NonNull String getSettingId(@NonNull String settingName) {
        if (this.componentID.isEmpty() || !settingName.contains(".") || settingName.contains("$")) {
            return settingName;
        }
        String[] nameList = settingName.split("\\.");
        return String.valueOf(this.componentID) + "." + nameList[nameList.length - 2] + "." + nameList[nameList.length - 1];
    }

    public @NonNull String getPeripheral() {
        return this.peripheral;
    }

    public @NonNull String getComponentID() {
        return this.componentID;
    }

    public boolean isSlice() {
        return this.isSlice;
    }

    public void setSlice(boolean isSlice) {
        this.isSlice = isSlice;
    }

    public @Nullable String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(@NonNull String filePath) {
        this.filePath = filePath;
    }
}

