/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.expression;

import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.expression.FunctionInvocation;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.expert.processor.properties.PackageProperties;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DependencyContextWrapper
implements IContext {
    @NonNull
    private IContext parentContext;
    @NonNull
    private @NonNull Collection<@NonNull String> usedSettings = new HashSet<String>();
    @NonNull
    private @NonNull Collection<@NonNull String> usedBitFields = new HashSet<String>();

    public DependencyContextWrapper(@NonNull IContext parentContext) {
        this.parentContext = parentContext;
    }

    public long getBitFieldValue(@NonNull String registerName, @NonNull String bitFieldName) {
        this.usedBitFields.add(this.getBitFieldId(registerName, bitFieldName));
        return this.parentContext.getBitFieldValue(registerName, bitFieldName);
    }

    public @NonNull Object getSettingValue(@NonNull String settingName) {
        ICommonConfig commonConfig;
        Object propertyValue;
        if (PackageProperties.isProperty((String)settingName) && (propertyValue = PackageProperties.getProperty((String)settingName, (IMcuIdentification)(commonConfig = SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig()).getMcuIdentification())) != null) {
            return propertyValue;
        }
        this.usedSettings.add(this.getSettingId(settingName));
        return this.parentContext.getSettingValue(settingName);
    }

    public int getBitFiledWidth(@NonNull String registerName, @NonNull String bitFieldName) {
        return this.parentContext.getBitFiledWidth(registerName, bitFieldName);
    }

    public @NonNull String getBitFieldId(@NonNull String registerName, @NonNull String bitFieldName) {
        return this.parentContext.getBitFieldId(registerName, bitFieldName);
    }

    public @NonNull String getSettingId(@NonNull String settingName) {
        return this.parentContext.getSettingId(settingName);
    }

    public @NonNull Collection<@NonNull String> getUsedSettings() {
        return this.usedSettings;
    }

    public @NonNull Collection<@NonNull String> getUsedBitFields() {
        return this.usedBitFields;
    }

    public @NonNull IValue resolveFunction(@NonNull FunctionInvocation function, @NonNull IContext argContext) {
        return this.parentContext.resolveFunction(function, argContext);
    }

    public @NonNull Set<@NonNull String> getAllUsedSettings(@NonNull IClocksConfig config) {
        HashSet<@NonNull String> settings = new HashSet<String>(this.getUsedSettings());
        for (String bitField : this.getUsedBitFields()) {
            ISetting bitFieldSetting = SettingProvider.getBitFieldSetting(bitField, config.getMcu());
            if (bitFieldSetting == null) continue;
            settings.add(bitFieldSetting.getId());
        }
        return settings;
    }
}

