/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.platform;

import com.nxp.swtools.clocks.platform.IPlatformSpecific;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;

public class PlatformSpecificFactory {
    @NonNull
    private static IPlatformSpecific PLATFORM_SPECIFIC;
    @NonNull
    private static final Logger LOGGER;

    static {
        IExtension[] extensions;
        LOGGER = LogManager.getLogger(PlatformSpecificFactory.class);
        IPlatformSpecific platform = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.nxp.swtools.clocks.platform");
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()) != null && extensions.length > 0) {
            IExtension extensionToUse = extensions[0];
            if (extensions.length > 1) {
                LOGGER.warning("More than one platform specific extensions found, using the first of them: " + extensionToUse.getUniqueIdentifier());
            }
            try {
                IConfigurationElement configElement = extensionToUse.getConfigurationElements()[0];
                platform = (IPlatformSpecific)configElement.createExecutableExtension("implementation");
            }
            catch (CoreException | InvalidRegistryObjectException e) {
                LOGGER.log(Level.SEVERE, "Cannot instantiate implementation of platform specific from extension: " + extensionToUse.getUniqueIdentifier(), e);
            }
        }
        if (platform == null) {
            throw new IllegalStateException("Cannot instantiate implementation of platform-specific API");
        }
        PLATFORM_SPECIFIC = platform;
    }

    public static @NonNull IPlatformSpecific getPlatformSpecific() {
        return PLATFORM_SPECIFIC;
    }

    protected static void setPlatformSpecific(@NonNull IPlatformSpecific platform) {
        PLATFORM_SPECIFIC = platform;
    }
}

