/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.resources;

import com.nxp.swtools.clocks.data.IMcuDescriptor;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.expert.processordb.IProcessorFilterForSwTools;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.resourcetables.model.resources.AProcessorFilterForResourceTable;
import java.util.List;
import java.util.logging.Logger;

@NonNullByDefault
public class ProcessorFilterForClocksTool
extends AProcessorFilterForResourceTable {
    public static final IProcessorFilterForSwTools.RequiredDbType DB_TYPE_CLOCKS_MODEL = new IProcessorFilterForSwTools.RequiredDbType("clocks_model", DB_TYPE_VERSION_1_0, DB_TYPE_VERSION_2_0);
    public static final IProcessorFilterForSwTools.RequiredDbType DB_TYPE_CLOCKS_SCRIPTS = new IProcessorFilterForSwTools.RequiredDbType("clocks_scripts", DB_TYPE_VERSION_1_0, DB_TYPE_VERSION_2_0);
    private static final ProcessorFilterForClocksTool INSTANCE = new ProcessorFilterForClocksTool();
    private static final Logger LOGGER = LogManager.getLogger(ProcessorFilterForClocksTool.class);

    private ProcessorFilterForClocksTool() {
        this.addRequrement(DB_TYPE_PACKAGE);
        this.addRequrement(DB_TYPE_REGISTERS);
        this.addRequrement(DB_TYPE_CLOCKS_MODEL);
        this.addRequrement(DB_TYPE_CLOCKS_SCRIPTS);
        this.addRequrement(DB_TYPE_CLOCKS_MODULES);
    }

    public static ProcessorFilterForClocksTool getInstance() {
        return INSTANCE;
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public static boolean isSupported(IMcuDescriptor descriptor) {
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(descriptor.getID(), descriptor.getSDKVersion());
        if (info == null) {
            LOGGER.warning("Cannot obtain Processor Master Tool Info for " + descriptor + ". MCU will be marked as unsupported.");
            return false;
        }
        return INSTANCE.isPartNumberSupported(info, descriptor.getPartNumber());
    }

    public static List<@NonNull String> getMissingRequirements(IMcuDescriptor descriptor) {
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(descriptor.getID(), descriptor.getSDKVersion());
        assert (info != null);
        return INSTANCE.getMissingRequirements(info, descriptor.getPartNumber(), derivatives);
    }

    public @NonNull String getToolId() {
        return "Clocks";
    }

    public static String getDbFileClockModel(IMcuIdentification mcu) {
        return INSTANCE.getRequiredDbFile(mcu, DB_TYPE_CLOCKS_MODEL);
    }

    public static String getDbFileClockModuls(IMcuIdentification mcu) {
        return INSTANCE.getRequiredDbFile(mcu, DB_TYPE_CLOCKS_MODULES);
    }

    public static String getDbFileClockScripts(IMcuIdentification mcu) {
        return INSTANCE.getRequiredDbFile(mcu, DB_TYPE_CLOCKS_SCRIPTS);
    }
}

