/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import com.nxp.swtools.clocks.ui.diagramsymbols.Fill;
import com.nxp.swtools.clocks.ui.diagramsymbols.ICollidable;
import com.nxp.swtools.clocks.ui.diagramsymbols.LineStyle;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Point;

public class BoundingBox
implements ICollidable {
    @NonNull
    private Point2D mTopLeftCornerDS;
    @NonNull
    private Point2D mBottomRightCornerDS;
    private boolean mIsValid;
    private static final double EPSILON = 0.001;

    public BoundingBox(@NonNull Point2D topLeftCornerDS, @NonNull Point2D bottomRightCornerDS) {
        this.mTopLeftCornerDS = topLeftCornerDS;
        this.mBottomRightCornerDS = bottomRightCornerDS;
        this.calculateValidity();
        this.orderCorners();
    }

    public BoundingBox() {
        this.mIsValid = false;
        this.mTopLeftCornerDS = new Point2D.Double();
        this.mBottomRightCornerDS = new Point2D.Double();
    }

    public boolean isValid() {
        return this.mIsValid;
    }

    public @NonNull Point2D getTopLeftCornerDS() {
        return this.mTopLeftCornerDS;
    }

    public @NonNull Point2D getBottomRightCornerDS() {
        return this.mBottomRightCornerDS;
    }

    public @NonNull Point2D getCenterDS() {
        double x = (this.mTopLeftCornerDS.getX() + this.mBottomRightCornerDS.getX()) / 2.0;
        double y = (this.mTopLeftCornerDS.getY() + this.mBottomRightCornerDS.getY()) / 2.0;
        return new Point2D.Double(x, y);
    }

    public void setTopLeftCorner(double xDS, double yDS) {
        this.mTopLeftCornerDS.setLocation(xDS, yDS);
        this.calculateValidity();
    }

    public void setBottomRightCorner(double xDS, double yDS) {
        this.mBottomRightCornerDS.setLocation(xDS, yDS);
        this.calculateValidity();
    }

    public void setTopLeftCorner(@NonNull Point2D topLeftDS) {
        this.mTopLeftCornerDS = topLeftDS;
        this.calculateValidity();
    }

    public double getWidth() {
        return this.mBottomRightCornerDS.getX() - this.mTopLeftCornerDS.getX();
    }

    public double getHeight() {
        return this.mBottomRightCornerDS.getY() - this.mTopLeftCornerDS.getY();
    }

    public void setBottomRightCorner(@NonNull Point2D bottomRightDS) {
        this.mBottomRightCornerDS = bottomRightDS;
        this.calculateValidity();
    }

    public @NonNull BoundingBox merge(@Nullable BoundingBox other) {
        if (other == null || !other.isValid()) {
            return this;
        }
        if (!this.mIsValid) {
            return other;
        }
        double minX = Math.min(this.mTopLeftCornerDS.getX(), other.getTopLeftCornerDS().getX());
        double maxX = Math.max(this.mBottomRightCornerDS.getX(), other.getBottomRightCornerDS().getX());
        double minY = Math.min(this.mTopLeftCornerDS.getY(), other.getTopLeftCornerDS().getY());
        double maxY = Math.max(this.mBottomRightCornerDS.getY(), other.getBottomRightCornerDS().getY());
        return new BoundingBox(new Point2D.Double(minX, minY), new Point2D.Double(maxX, maxY));
    }

    public void orderCorners() {
        double minX = Math.min(this.mTopLeftCornerDS.getX(), this.mBottomRightCornerDS.getX());
        double maxX = Math.max(this.mTopLeftCornerDS.getX(), this.mBottomRightCornerDS.getX());
        double minY = Math.min(this.mTopLeftCornerDS.getY(), this.mBottomRightCornerDS.getY());
        double maxY = Math.max(this.mTopLeftCornerDS.getY(), this.mBottomRightCornerDS.getY());
        this.mTopLeftCornerDS.setLocation(minX, minY);
        this.mBottomRightCornerDS.setLocation(maxX, maxY);
    }

    public void draw(@NonNull AffineTransform trans, @NonNull PaintEvent e, @Nullable Fill fill, @Nullable LineStyle style) {
        Point2D tlcCS = trans.transform(this.mTopLeftCornerDS, null);
        Point2D brcCS = trans.transform(this.mBottomRightCornerDS, null);
        Point size = new Point((int)(brcCS.getX() - tlcCS.getX()), (int)(brcCS.getY() - tlcCS.getY()));
        if (fill != null && !fill.isTransparent()) {
            fill.set(e);
            e.gc.fillRectangle((int)tlcCS.getX(), (int)tlcCS.getY(), size.x, size.y);
            fill.unset(e);
        }
        if (style != null) {
            style.set(e);
            e.gc.drawRectangle((int)tlcCS.getX(), (int)tlcCS.getY(), size.x, size.y);
            style.unset(e);
        }
    }

    private void calculateValidity() {
        double diffX = this.mTopLeftCornerDS.getX() - this.mBottomRightCornerDS.getX();
        double diffY = this.mTopLeftCornerDS.getY() - this.mBottomRightCornerDS.getY();
        this.mIsValid = Math.abs(diffX) > 0.001 || Math.abs(diffY) > 0.001;
    }

    @Override
    public boolean isHitBy(@NonNull Point2D p) {
        return this.isValid() && p.getX() >= this.mTopLeftCornerDS.getX() && p.getX() <= this.mBottomRightCornerDS.getX() && p.getY() >= this.mTopLeftCornerDS.getY() && p.getY() <= this.mBottomRightCornerDS.getY();
    }

    @Override
    public @NonNull List<@NonNull Point2D> getHullPoints() {
        ArrayList<@NonNull Point2D> points = new ArrayList<Point2D>();
        points.add(this.mBottomRightCornerDS);
        points.add(this.mTopLeftCornerDS);
        points.add(new Point2D.Double(this.mTopLeftCornerDS.getX(), this.mBottomRightCornerDS.getY()));
        points.add(new Point2D.Double(this.mBottomRightCornerDS.getX(), this.mTopLeftCornerDS.getY()));
        return points;
    }
}

