/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.view;

import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.platform.Rap;
import com.nxp.swtools.clocks.ui.DetailsWindow;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.clocks.ui.table.SettingsFilter;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.utils.view.ToolView;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;

public class DetailsView
extends ToolView {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(DetailsView.class);
    @NonNull
    public static final String ID = "com.nxp.swtools.clocks.DetailsView";
    @Nullable
    Composite mainComposite;
    private DetailsWindow detailsWindow;
    private IAction activeFilter;
    private IAction lockFilter;
    private IAction problemFilter;

    public void createPartControl(Composite parent) {
        Composite defaultComposite;
        this.mainComposite = defaultComposite = this.createDefaultComposite(parent);
        defaultComposite.setLayout((Layout)new FillLayout());
        if (!Rap.isActive()) {
            this.createToolbarButtons();
        }
        this.detailsWindow = DetailsView.createDetails(defaultComposite);
    }

    private static @NonNull DetailsWindow createDetails(@NonNull Composite parent) {
        return new DetailsWindow(parent);
    }

    public void setFocus() {
        Composite mainCompositeLoc = this.mainComposite;
        if (mainCompositeLoc != null) {
            mainCompositeLoc.setFocus();
        }
    }

    private void createToolbarButtons() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        GuiController controller = GuiController.getInstance();
        if (toolBar != null) {
            toolBar.add(controller.createToolbarAction("icons/top_level.png", Messages.get().DetailsView_ShowAllElements, "clocksShowAllElements", () -> controller.setSelectedElement(null, (Object)this)));
            this.activeFilter = controller.createToolbarAction("icons/show_active_inverted.png", Messages.get().DetailsView_ShowActive, "clocksDetachDetailsFilter", 2, () -> this.updateFilter());
            toolBar.add(this.activeFilter);
            this.lockFilter = controller.createToolbarAction("icons/locked.png", Messages.get().DetailsView_ShowLocked, "clocksLockedDetailsFilter", 2, () -> this.updateFilter());
            toolBar.add(this.lockFilter);
            this.problemFilter = controller.createToolbarAction("icons/problems.png", Messages.get().DetailsView_ShowProblems, "clocksErroneoussDetailsFilter", 2, () -> this.updateFilter());
            toolBar.add(this.problemFilter);
            toolBar.add(controller.createToolbarAction("icons/detach.png", Messages.get().DetailsView_detachDetails, "clocksDetachDetails", () -> controller.openShellWithSettingsOfSelectedElement()));
        } else {
            LOGGER.severe("Cannot create buttons in toolbar, as toolbar manager cannot be obtained");
            assert (false);
        }
    }

    private void updateFilter() {
        IClocksConfig activeConfig = GuiController.getInstance().getProfile().getActiveConfig();
        if (activeConfig != null) {
            SettingsFilter settingsFilter = new SettingsFilter(activeConfig);
            if (this.activeFilter.isChecked()) {
                settingsFilter.andPredicate(settingsFilter.activePredicate());
            }
            if (this.lockFilter.isChecked()) {
                settingsFilter.andPredicate(settingsFilter.lockedPredicate());
            }
            if (this.problemFilter.isChecked()) {
                settingsFilter.andPredicate(settingsFilter.errorneousPredicate());
            }
            this.detailsWindow.setFilter(settingsFilter);
            this.detailsWindow.refreshInput();
        }
    }
}

