/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.freertos.model;

import com.freescale.s32ds.debug.ka.KAPluginActivator;
import com.freescale.s32ds.debug.ka.dsf.DSFInterface;
import com.freescale.s32ds.debug.ka.freertos.controller.FreeRTOSIStoreManager;
import com.freescale.s32ds.debug.ka.freertos.model.NumericalData;
import com.freescale.s32ds.debug.ka.freertos.model.QueueTypeData;
import com.freescale.s32ds.debug.ka.model.OSAbstractData;
import com.freescale.s32ds.debug.ka.model.OSDataStructure;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RTOSQueue
extends OSDataStructure {
    private String name;
    private String address;
    private String sTasksWaitingToSendListAddress;
    private String sTasksWaitingToReceiveListAddress;
    private List<String> invalidIndexes = new LinkedList<String>();

    public RTOSQueue(IRunControl.IExecutionDMContext context, String name, String address, FreeRTOSIStoreManager storeManager) {
        this.name = name;
        this.address = address;
        this.lAddress = Long.decode(address);
        this.bValid = true;
        this.sStructureStartQueryString = "((xQUEUE*)pxCurrentTCB)";
        this.sStructureSizeQueryString = "sizeof(xQUEUE)";
        this.sStructureMemberQueryString = "&(((xQUEUE*)pxCurrentTCB)->";
        this.data.put("length", new NumericalData(context, "uxLength", storeManager));
        this.data.put("itemSize", new NumericalData(context, "uxItemSize", storeManager));
        this.data.put("messagesWaiting", new NumericalData(context, "uxMessagesWaiting", storeManager));
        this.data.put("sendTasks", new NumericalData(context, "xTasksWaitingToSend.uxNumberOfItems", storeManager));
        this.data.put("receiveTasks", new NumericalData(context, "xTasksWaitingToReceive.uxNumberOfItems", storeManager));
        this.data.put("type", new QueueTypeData(context, "ucQueueType", storeManager));
        this.prvObtainStructure(context, this.invalidIndexes);
        this.prvGetListAddresses(context);
    }

    private void prvGetListAddresses(IRunControl.IExecutionDMContext context) {
        try {
            if (DSFInterface.getDefault() != null) {
                this.sTasksWaitingToSendListAddress = DSFInterface.getDefault().sEvaluateExpression(context, "(&((((xQUEUE*)" + this.lAddress + ")->xTasksWaitingToSend)))").split(" ")[0];
                this.sTasksWaitingToReceiveListAddress = DSFInterface.getDefault().sEvaluateExpression(context, "(&((((xQUEUE*)" + this.lAddress + ")->xTasksWaitingToReceive)))").split(" ")[0];
            }
        }
        catch (ExecutionException e) {
            KAPluginActivator.log((IStatus)new Status(4, "com.freescale.s32ds.viewer.freertos", "prvGetListAddresses: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public String getTxQueueAddress() {
        return this.sTasksWaitingToSendListAddress;
    }

    public String getRxQueueAddress() {
        return this.sTasksWaitingToReceiveListAddress;
    }

    public String getQueueName() {
        return this.name;
    }

    public String getQueueAddress() {
        return this.address;
    }

    public String getQueueMaxLength() {
        return ((OSAbstractData)this.data.get("length")).getValue();
    }

    public String getQueueItemSize() {
        return ((OSAbstractData)this.data.get("itemSize")).getValue();
    }

    public String getQueueCurrentLength() {
        return ((OSAbstractData)this.data.get("messagesWaiting")).getValue();
    }

    public String getQueueNumberOfWaitingToSendTasks() {
        return ((OSAbstractData)this.data.get("sendTasks")).getValue();
    }

    public String getQueueNumberOfWaitingToRecieiveTasks() {
        return ((OSAbstractData)this.data.get("receiveTasks")).getValue();
    }

    public String getQueueType() {
        return ((OSAbstractData)this.data.get("type")).getValue();
    }
}

