/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.migration.entity;

import com.nxp.s32ds.cle.runtime.migration.entity.MigrationEntity;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CTMigrationEntity
implements MigrationEntity {
    private static final Logger LOGGER = LogManager.getLogger(CTMigrationEntity.class);
    private static final String BUNDLE_ID = "com.nxp.s32ds.cle.s32v2.s32v2.ct.migration.entity";

    public IStatus migrate(String sourceId, String targetId, Map<String, Object> attributes, IProgressMonitor monitor) {
        if (attributes == null) {
            return Status.CANCEL_STATUS;
        }
        IProject project = (IProject)attributes.get("s32ds.migration.payload.attributes.project");
        try {
            CTMigrationEntity.updateSdkId(project, sourceId, targetId);
        }
        catch (IOException | CoreException e) {
            return new Status(4, BUNDLE_ID, e.getMessage());
        }
        LOGGER.log(Level.INFO, "Migration completed...");
        return Status.OK_STATUS;
    }

    private static void updateSdkId(IProject project, String sourceId, String targetId) throws CoreException, IOException {
        IResource[] members = project.members();
        ArrayDeque<IResource> stack = new ArrayDeque<IResource>();
        stack.addAll(Arrays.asList(members));
        while (!stack.isEmpty()) {
            IResource resource = (IResource)stack.pop();
            if (resource instanceof IFile) {
                if (!"mex".equals(resource.getFileExtension()) && !".project".equals(resource.getName()) && !Arrays.asList(resource.getFullPath().segments()).stream().filter(s -> s.equals("board")).findAny().isPresent()) continue;
                CTMigrationEntity.replaceInFile((IFile)resource, sourceId, targetId);
                continue;
            }
            if (!(resource instanceof IFolder) || !"board".equals(resource.getName())) continue;
            IResource[] folderMembers = ((IFolder)resource).members();
            stack.addAll(Arrays.asList(folderMembers));
        }
    }

    private static void replaceInFile(IFile file, String sourceId, String targetId) throws IOException {
        LOGGER.log(Level.INFO, String.format("CTMigrationEntity.migrate() file: %s will be migrated from source: %s to target: %s", file, sourceId, targetId));
        byte[] b = Files.readAllBytes(Paths.get(file.getLocationURI()));
        String s = new String(b);
        if (s.contains(sourceId)) {
            s = s.replaceAll(sourceId, targetId);
            FileWriter w = new FileWriter(file.getLocation().toOSString());
            w.write(s);
            w.close();
        }
    }

    public IStatus applicable(String sourceId, String targetId, Map<String, Object> attributes) {
        IProject project = (IProject)attributes.get("s32ds.migration.payload.attributes.project");
        if (project != null && project.isAccessible()) {
            return Status.OK_STATUS;
        }
        if (sourceId != null && targetId != null && !sourceId.equals(targetId)) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }
}

