/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.orbit.c.includes;

import com.nxp.s32ds.ext.orbit.c.CParseException;
import com.nxp.s32ds.ext.orbit.c.defines.CDefine;
import com.nxp.s32ds.ext.orbit.c.defines.CExternalDefine;
import com.nxp.s32ds.ext.orbit.c.defines.impl.CDefineImpl;
import com.nxp.s32ds.ext.orbit.c.defines.impl.CExternalDefineImpl;
import com.nxp.s32ds.ext.orbit.c.includes.CInclude;
import com.nxp.s32ds.ext.orbit.c.includes.CIncludePathResolver;
import com.nxp.s32ds.ext.orbit.internal.c.Messages;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osgi.util.NLS;

public class CIncludes {
    private static final Pattern pattern = Pattern.compile("#\\s*define\\s+(\\w+)\\s+(.+)");

    private CIncludes() {
    }

    public static Collection<CExternalDefine> parse(CInclude include, CIncludePathResolver resolver) throws CParseException {
        Path path;
        String strPath = include.getPath();
        if (strPath == null || strPath.trim().isEmpty()) {
            throw new CParseException(Messages.includes_include_file_name_is_empty);
        }
        if (resolver == null) {
            path = Paths.get(strPath, new String[0]).normalize();
        } else {
            try {
                path = Paths.get(resolver.resolve(strPath), new String[0]).normalize();
            }
            catch (Exception e) {
                throw new CParseException(CIncludes.createMessage(strPath, e.getMessage()), e);
            }
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new CParseException(CIncludes.createMessage(strPath, NLS.bind((String)Messages.file_not_found_0, (Object)strPath)));
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new CParseException(CIncludes.createMessage(strPath, NLS.bind((String)Messages.is_not_a_file_0, (Object)strPath)));
        }
        try {
            return CIncludes.parseFile(path).stream().map(i -> new CExternalDefineImpl(i.getName(), i.getValue(), include)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new CParseException(CIncludes.createMessage(strPath, e.getMessage()), e);
        }
    }

    public static List<CDefine> parseFile(Path path) throws IOException {
        Throwable throwable = null;
        Object var2_4 = null;
        try (Stream<String> stream = Files.lines(path);){
            return stream.map(l -> CIncludes.parseLine(l)).filter(it -> it != null).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static CDefine parseLine(String line) {
        Matcher matcher;
        String[] split = line.split("//");
        if (split.length == 0) {
            return null;
        }
        String strConstant = split[0].trim();
        if (!strConstant.isEmpty() && (matcher = pattern.matcher(strConstant)).find()) {
            return new CDefineImpl(matcher.group(1), matcher.group(2));
        }
        return null;
    }

    private static String createMessage(String fileName, String message) {
        return NLS.bind((String)Messages.includes_cannot_parse_0_caused_by_1, (Object)fileName, (Object)message);
    }
}

