/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.internal.registry.core;

import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkDescriptorUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.hardware.HardwareSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.lang.LangSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.platform.PlatformHostSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.platform.PlatformTargetSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.platform.PlatformHostSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.platform.PlatformTargetSdkDescriptor;
import com.nxp.s32ds.ext.rcp.registry.ElementDescriptor;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SdkDescriptorImplementation
extends ElementDescriptor
implements SdkDescriptor {
    private SdkType sdkType;

    public SdkDescriptorImplementation(Element element) {
        super(element);
        this.addSubstitution("name", "name");
        this.addSubstitution("description", "description");
    }

    public SdkDescriptorImplementation(Element element, SdkType sdkType) {
        this(element);
        this.sdkType = sdkType;
    }

    public String getId() {
        return SdkDescriptorUtils.makeId(this.getName(), this.getVersion());
    }

    public String getVersion() {
        return this.getAttribute("version");
    }

    public String getBasePath() {
        return this.getAttribute("basePath");
    }

    public String getExternalId() {
        return this.getAttribute("externalId");
    }

    public String getTargetFolderName() {
        return this.getAttribute("targetFolderName");
    }

    public String getTargetProjectTemplate() {
        return this.getAttribute("targetProjectTemplate");
    }

    public String getDescriptorPath() {
        return this.getAttribute("descriptorPath");
    }

    public boolean isLoadedByUser() {
        return Boolean.parseBoolean(this.getAttribute("isLoadedByUser"));
    }

    public Set<String> getTags() {
        return Arrays.stream(this.getAttribute("tags").split(",")).map(String::trim).filter(tag -> !tag.isEmpty()).collect(Collectors.toSet());
    }

    public String getLangs() {
        return this.getAttribute("langs");
    }

    public String getPlatformTarget() {
        PlatformTargetSdkDescriptor platformTargetSdkDescriptor = PlatformTargetSdkDescriptors.getPlatformTargetSdkDescriptorBySdkId(this.getId());
        return platformTargetSdkDescriptor != null ? platformTargetSdkDescriptor.getSourceId() : "";
    }

    public String getPlatformHost() {
        PlatformHostSdkDescriptor platformHostSdkDescriptor = PlatformHostSdkDescriptors.getPlatformHostSdkDescriptorBySdkId(this.getId());
        return platformHostSdkDescriptor != null ? platformHostSdkDescriptor.getSourceId() : "";
    }

    public SdkType getType() {
        return this.sdkType;
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SdkDescriptorImplementation)) {
            return false;
        }
        SdkDescriptorImplementation other = (SdkDescriptorImplementation)((Object)obj);
        return this.getId().equals(other.getId());
    }

    public String toString() {
        String targetFolderName;
        String langs;
        StringBuilder sb = new StringBuilder();
        sb.append("SDK: id=").append(this.getId()).append(" type=").append(this.getType()).append(" name=").append(this.getName()).append(" version=").append(this.getVersion()).append(" basePath=").append(this.getBasePath());
        String description = this.getDescription();
        if (!description.isEmpty()) {
            sb.append(" description=").append(description);
        }
        if (!(langs = this.getLangs()).isEmpty()) {
            sb.append(" langs=").append(langs);
        }
        if (!(targetFolderName = this.getTargetFolderName()).isEmpty() && !targetFolderName.equals(this.getName())) {
            sb.append(" targetFolder=").append(targetFolderName);
        }
        sb.append(this.hardwareParamsToString());
        sb.append(this.extendedParamsToString());
        return sb.toString();
    }

    private String hardwareParamsToString() {
        StringBuilder sb = new StringBuilder();
        Map<String, Set<String>> hardware = HardwareSdkDescriptors.getHardwareSdkDescriptorsIds(this.getId());
        if (!hardware.isEmpty()) {
            Set<String> cores;
            Set<String> deviceCores;
            Set<String> devices = hardware.get("com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
            if (!devices.isEmpty()) {
                sb.append(" devices=").append(String.join((CharSequence)",", devices));
            }
            if (!(deviceCores = hardware.get("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id")).isEmpty()) {
                sb.append(" deviceCores=").append(String.join((CharSequence)",", deviceCores));
            }
            if (!(cores = hardware.get("com.nxp.s32ds.cle.runtime.hardware.registry.core.id")).isEmpty()) {
                sb.append(" cores=").append(String.join((CharSequence)",", cores));
            }
        }
        return sb.toString();
    }

    private String extendedParamsToString() {
        String descriptorPath;
        String externalId;
        String projectTemplate;
        StringBuilder sb = new StringBuilder();
        Set<String> tags = this.getTags();
        if (!tags.isEmpty()) {
            sb.append(" tags=").append(String.join((CharSequence)",", tags));
        }
        if (!(projectTemplate = this.getTargetProjectTemplate()).isEmpty()) {
            sb.append(" projectTemplate=").append(projectTemplate);
        }
        if (!(externalId = this.getExternalId()).isEmpty()) {
            sb.append(" externalId=").append(externalId);
        }
        if (!(descriptorPath = this.getDescriptorPath()).isEmpty()) {
            sb.append(" descriptorPath=").append(descriptorPath);
        }
        String platformHost = this.getPlatformHost();
        String platformTarget = this.getPlatformTarget();
        if (!platformHost.isEmpty() || !platformTarget.isEmpty()) {
            sb.append(" platform=").append(platformHost).append("|").append(platformTarget);
        }
        if (this.isLoadedByUser()) {
            sb.append(" isLoadedByUser=yes");
        }
        return sb.toString();
    }

    public Element convertToXml(Document document, Element holderElement) {
        Set<String> tags;
        String descriptorPath;
        String externalId;
        Element sdkElement = document.createElement("sdk");
        sdkElement.setAttribute("name", this.getName());
        sdkElement.setAttribute("version", this.getVersion());
        sdkElement.setAttribute("basePath", this.getBasePath());
        String description = this.getDescription();
        if (!description.isEmpty()) {
            sdkElement.setAttribute("description", description);
        }
        LangSdkDescriptors.convertToXml(this.getId(), document, sdkElement);
        String hardwareParams = this.getAttribute("cores");
        if (!hardwareParams.isEmpty()) {
            sdkElement.setAttribute("cores", hardwareParams);
            HardwareSdkDescriptors.convertToXml(this.getId(), document, sdkElement);
        }
        sdkElement.setAttribute("targetFolderName", this.getAttribute("targetFolderName"));
        String targetProjectTemplate = this.getTargetProjectTemplate();
        if (!targetProjectTemplate.isEmpty()) {
            sdkElement.setAttribute("targetProjectTemplate", targetProjectTemplate);
        }
        if (!(externalId = this.getExternalId()).isEmpty()) {
            sdkElement.setAttribute("externalId", externalId);
        }
        if (!(descriptorPath = this.getDescriptorPath()).isEmpty()) {
            sdkElement.setAttribute("descriptorPath", descriptorPath);
        }
        if (!(tags = this.getTags()).isEmpty()) {
            sdkElement.setAttribute("tags", String.join((CharSequence)",", tags));
        }
        if (this.isLoadedByUser()) {
            sdkElement.setAttribute("isLoadedByUser", Boolean.TRUE.toString());
        }
        holderElement.appendChild(sdkElement);
        return sdkElement;
    }
}

